/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSWritableList;
import com.helger.css.decl.IHasCSSDeclarations;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSDeclarationList
extends CSSWritableList<CSSDeclaration>
implements IHasCSSDeclarations<CSSDeclarationList> {
    @Override
    public final @NonNull CSSDeclarationList addDeclaration(@NonNull CSSDeclaration cSSDeclaration) {
        this.add(cSSDeclaration);
        return this;
    }

    @Override
    public @NonNull CSSDeclarationList addDeclaration(@Nonnegative int n, @NonNull CSSDeclaration cSSDeclaration) {
        this.add(n, cSSDeclaration);
        return this;
    }

    @Override
    public final @NonNull EChange removeDeclaration(@NonNull CSSDeclaration cSSDeclaration) {
        return this.removeObject(cSSDeclaration);
    }

    @Override
    public final @NonNull EChange removeDeclaration(@Nonnegative int n) {
        return this.removeAtIndex(n);
    }

    @Override
    public @NonNull EChange removeAllDeclarations() {
        return this.removeAll();
    }

    @Override
    @ReturnsMutableCopy
    public final @NonNull ICommonsList<CSSDeclaration> getAllDeclarations() {
        return this.getClone();
    }

    @Override
    public final @Nullable CSSDeclaration getDeclarationAtIndex(@Nonnegative int n) {
        return (CSSDeclaration)this.getAtIndex(n);
    }

    @Override
    public @NonNull CSSDeclarationList setDeclarationAtIndex(@Nonnegative int n, @NonNull CSSDeclaration cSSDeclaration) {
        this.set(n, cSSDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.isNotEmpty();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.size();
    }

    @Override
    public @Nullable CSSDeclaration getDeclarationOfPropertyName(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (CSSDeclaration)this.findFirst(cSSDeclaration -> cSSDeclaration.hasProperty(string));
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String string) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (StringHelper.isNotEmpty((String)string)) {
            this.findAll(cSSDeclaration -> cSSDeclaration.hasProperty(string), arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        }
        return commonsArrayList;
    }
}

