/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.ICSSPageRuleMember;
import com.helger.css.property.ECSSProperty;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSDeclaration
implements ICSSSourceLocationAware,
ICSSPageRuleMember {
    public static final boolean DEFAULT_IMPORTANT = false;
    private String m_sProperty;
    private CSSExpression m_aExpression;
    private boolean m_bIsImportant;
    private CSSSourceLocation m_aSourceLocation;

    public CSSDeclaration(@Nonempty @NonNull String string, @NonNull CSSExpression cSSExpression) {
        this(string, cSSExpression, false);
    }

    public CSSDeclaration(@Nonempty @NonNull String string, @NonNull CSSExpression cSSExpression, boolean bl) {
        this.setProperty(string);
        this.setExpression(cSSExpression);
        this.setImportant(bl);
    }

    @Nonempty
    public final @NonNull String getProperty() {
        return this.m_sProperty;
    }

    private static @NonNull String _unifyProperty(@NonNull String string) {
        if (string.startsWith("--")) {
            return string;
        }
        return string.toLowerCase(Locale.ROOT);
    }

    public final boolean hasProperty(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Property");
        return this.m_sProperty.equals(CSSDeclaration._unifyProperty(string));
    }

    public final boolean hasProperty(@NonNull ECSSProperty eCSSProperty) {
        ValueEnforcer.notNull((Object)((Object)eCSSProperty), (String)"Property");
        return this.hasProperty(eCSSProperty.getName());
    }

    public final @NonNull CSSDeclaration setProperty(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Property");
        this.m_sProperty = CSSDeclaration._unifyProperty(string);
        return this;
    }

    public final @NonNull CSSDeclaration setProperty(@NonNull ECSSProperty eCSSProperty) {
        ValueEnforcer.notNull((Object)((Object)eCSSProperty), (String)"Property");
        return this.setProperty(eCSSProperty.getName());
    }

    @ReturnsMutableObject
    public final @NonNull CSSExpression getExpression() {
        return this.m_aExpression;
    }

    public final @NonNull String getExpressionAsCSSString() {
        return this.m_aExpression.getAsCSSString();
    }

    public final @NonNull CSSDeclaration setExpression(@NonNull CSSExpression cSSExpression) {
        this.m_aExpression = (CSSExpression)ValueEnforcer.notNull((Object)cSSExpression, (String)"Expression");
        return this;
    }

    public final boolean isImportant() {
        return this.m_bIsImportant;
    }

    public final @NonNull CSSDeclaration setImportant(boolean bl) {
        this.m_bIsImportant = bl;
        return this;
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.m_sProperty + ":" + this.m_aExpression.getAsCSSString(iCSSWriterSettings, n) + (this.m_bIsImportant ? " !important" : "");
    }

    @Override
    public final @Nullable CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSDeclaration cSSDeclaration = (CSSDeclaration)object;
        return this.m_sProperty.equals(cSSDeclaration.m_sProperty) && this.m_aExpression.equals(cSSDeclaration.m_aExpression) && this.m_bIsImportant == cSSDeclaration.m_bIsImportant;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sProperty).append((Object)this.m_aExpression).append(this.m_bIsImportant).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("property", (Object)this.m_sProperty).append("expression", (Object)this.m_aExpression).append("important", this.m_bIsImportant).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

