/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSExpressionMemberMathProduct;
import com.helger.css.decl.ICSSExpressionMathMember;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class CSSExpressionMemberMathUnitProduct
implements ICSSExpressionMathMember,
ICSSSourceLocationAware {
    private final CSSExpressionMemberMathProduct m_aProduct;

    public CSSExpressionMemberMathUnitProduct(@Nonnull @Nonempty CSSExpressionMemberMathProduct cSSExpressionMemberMathProduct) {
        this.m_aProduct = (CSSExpressionMemberMathProduct)ValueEnforcer.notNull((Object)cSSExpressionMemberMathProduct, (String)"Product");
    }

    @Nonnull
    public final CSSExpressionMemberMathProduct getProduct() {
        return this.m_aProduct;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return "(" + this.m_aProduct.getAsCSSString(iCSSWriterSettings, n) + ")";
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aProduct.getSourceLocation();
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aProduct.setSourceLocation(cSSSourceLocation);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberMathUnitProduct cSSExpressionMemberMathUnitProduct = (CSSExpressionMemberMathUnitProduct)object;
        return this.m_aProduct.equals(cSSExpressionMemberMathUnitProduct.m_aProduct);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aProduct).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("product", (Object)this.m_aProduct).getToString();
    }
}

