/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.propertyvalue;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.ICSSProperty;
import com.helger.css.propertyvalue.CSSValue;
import com.helger.css.propertyvalue.ICSSMultiValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CSSValueMultiProperty
implements ICSSMultiValue {
    private final ECSSProperty m_eProperty;
    private final ICommonsList<CSSValue> m_aValues = new CommonsArrayList();

    public CSSValueMultiProperty(@Nonnull ECSSProperty eCSSProperty, @Nonnull ICSSProperty[] iCSSPropertyArray, @Nonnull @Nonempty String string, boolean bl) {
        ValueEnforcer.notNull((Object)eCSSProperty, (String)"Property");
        ValueEnforcer.notEmptyNoNullValue((Object[])iCSSPropertyArray, (String)"Properties");
        ValueEnforcer.notNull((Object)string, (String)"Value");
        boolean bl2 = false;
        for (ICSSProperty iCSSProperty : iCSSPropertyArray) {
            if (iCSSProperty.getProp() != eCSSProperty) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            throw new IllegalArgumentException("The property " + String.valueOf(eCSSProperty) + " is not contained in an ICSSProperty instance!");
        }
        this.m_eProperty = eCSSProperty;
        for (ICSSProperty iCSSProperty : iCSSPropertyArray) {
            this.m_aValues.add((Object)new CSSValue(iCSSProperty, string, bl));
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSValue> getAllContainedValues() {
        return (ICommonsList)this.m_aValues.getClone();
    }

    @Override
    @Nonnull
    public ECSSProperty getProp() {
        return this.m_eProperty;
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return StringHelper.getImplodedMapped(this.m_aValues, cSSValue -> cSSValue.getAsCSSString(iCSSWriterSettings, n));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSValueMultiProperty cSSValueMultiProperty = (CSSValueMultiProperty)object;
        return this.m_aValues.equals(cSSValueMultiProperty.m_aValues);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aValues).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("values", this.m_aValues).getToString();
    }
}

