/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.media;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.css.media.ECSSMedium;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ICSSMediaList
extends Serializable {
    @Nonnegative
    public int getMediaCount();

    default public boolean hasAnyMedia() {
        return !this.hasNoMedia();
    }

    public boolean hasNoMedia();

    default public boolean hasNoMediaOrAll() {
        return this.hasNoMedia() || this.containsMedium(ECSSMedium.ALL);
    }

    public boolean containsMedium(@Nullable ECSSMedium var1);

    default public boolean containsMediumOrAll(@Nullable ECSSMedium eCSSMedium) {
        return this.containsMedium(eCSSMedium) || this.containsMedium(ECSSMedium.ALL);
    }

    default public boolean isForScreen() {
        return this.hasNoMedia() || this.containsMediumOrAll(ECSSMedium.SCREEN);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<ECSSMedium> getAllMedia();

    @Nonnull
    public String getMediaString();

    @Nonnull
    public String getMediaString(@Nonnull String var1);
}

