/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.ECSSVersion;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.ICSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import com.helger.css.propertyvalue.CSSValue;
import com.helger.css.propertyvalue.ICSSValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractCSSProperty
implements ICSSProperty {
    private final ECSSProperty m_eProp;
    private final ECSSVendorPrefix m_eVendorPrefix;
    private final ICSSPropertyCustomizer m_aCustomizer;

    protected AbstractCSSProperty(@Nonnull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer) {
        this.m_eProp = (ECSSProperty)ValueEnforcer.notNull((Object)eCSSProperty, (String)"Property");
        this.m_eVendorPrefix = eCSSVendorPrefix;
        this.m_aCustomizer = iCSSPropertyCustomizer;
        if (eCSSProperty.isVendorSpecific() && eCSSVendorPrefix != null) {
            throw new IllegalStateException("You cannot use the vendor prefix " + (Object)((Object)eCSSVendorPrefix) + " on the already vendor specific property " + eCSSProperty);
        }
    }

    @Override
    @Nonnull
    public final ECSSVersion getMinimumCSSVersion() {
        return this.m_eProp.getMinimumCSSVersion();
    }

    @Override
    @Nonnull
    public final ECSSProperty getProp() {
        return this.m_eProp;
    }

    @Override
    @Nullable
    public final ECSSVendorPrefix getVendorPrefix() {
        return this.m_eVendorPrefix;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getPropertyName() {
        if (this.m_eVendorPrefix != null) {
            return this.m_eVendorPrefix.getPrefix() + this.m_eProp.getName();
        }
        return this.m_eProp.getName();
    }

    @Override
    @Nullable
    public final ICSSPropertyCustomizer getCustomizer() {
        return this.m_aCustomizer;
    }

    @Override
    @Nonnegative
    @OverrideOnDemand
    public int getMinimumArgumentCount() {
        return 1;
    }

    @Override
    @Nonnegative
    @OverrideOnDemand
    public int getMaximumArgumentCount() {
        return 1;
    }

    public static boolean isValidPropertyValue(@Nullable String string) {
        return "inherit".equals(string) || "initial".equals(string);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String string) {
        return AbstractCSSProperty.isValidPropertyValue(string);
    }

    @Override
    @Nonnull
    public ICSSValue newValue(@Nonnull @Nonempty String string, boolean bl) {
        ICSSValue iCSSValue;
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Value");
        if (this.m_aCustomizer != null && (iCSSValue = this.m_aCustomizer.createSpecialValue(this, string, bl)) != null) {
            return iCSSValue;
        }
        return new CSSValue(this, string, bl);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractCSSProperty abstractCSSProperty = (AbstractCSSProperty)object;
        return this.m_eProp.equals(abstractCSSProperty.m_eProp);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eProp).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("prop", (Enum)this.m_eProp).toString();
    }
}

