/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader.errorhandler;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.Token;
import com.helger.css.reader.errorhandler.CSSParseError;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CollectingCSSParseErrorHandler
implements ICSSParseErrorHandler {
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final List<CSSParseError> m_aErrors = new ArrayList<CSSParseError>();
    private final ICSSParseErrorHandler m_aNestedErrorHandler;

    public CollectingCSSParseErrorHandler() {
        this(null);
    }

    public CollectingCSSParseErrorHandler(@Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        this.m_aNestedErrorHandler = iCSSParseErrorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCSSParseError(@Nonnull Token token, @Nonnull int[][] nArray, @Nonnull String[] stringArray, @Nullable Token token2) throws ParseException {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aErrors.add(new CSSParseError(token, nArray, stringArray, token2));
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (this.m_aNestedErrorHandler != null) {
            this.m_aNestedErrorHandler.onCSSParseError(token, nArray, stringArray, token2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCSSUnexpectedRule(@Nonnull Token token, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) throws ParseException {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aErrors.add(CSSParseError.createUnexpectedRule(token, string, string2));
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        if (this.m_aNestedErrorHandler != null) {
            this.m_aNestedErrorHandler.onCSSUnexpectedRule(token, string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public boolean hasParseErrors() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = !this.m_aErrors.isEmpty();
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public int getParseErrorCount() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = this.m_aErrors.size();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSParseError> getAllParseErrors() {
        this.m_aRWLock.readLock().lock();
        try {
            List list = CollectionHelper.newList(this.m_aErrors);
            return list;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("errors", this.m_aErrors).toString();
    }
}

