/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSMediaQuery;
import com.helger.css.decl.CSSURI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSImportRule
implements ICSSWriteable,
ICSSSourceLocationAware {
    private CSSURI m_aLocation;
    private final List<CSSMediaQuery> m_aMediaQueries = new ArrayList<CSSMediaQuery>();
    private CSSSourceLocation m_aSourceLocation;

    public CSSImportRule(@Nonnull String string) {
        this(new CSSURI(string));
    }

    public CSSImportRule(@Nonnull CSSURI cSSURI) {
        this.setLocation(cSSURI);
    }

    public boolean hasMediaQueries() {
        return !this.m_aMediaQueries.isEmpty();
    }

    @Nonnegative
    public int getMediaQueryCount() {
        return this.m_aMediaQueries.size();
    }

    @Nonnull
    public CSSImportRule addMediaQuery(@Nonnull CSSMediaQuery cSSMediaQuery) {
        ValueEnforcer.notNull((Object)cSSMediaQuery, (String)"MediaQuery");
        this.m_aMediaQueries.add(cSSMediaQuery);
        return this;
    }

    @Nonnull
    public CSSImportRule addMediaQuery(@Nonnegative int n, @Nonnull CSSMediaQuery cSSMediaQuery) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSMediaQuery, (String)"MediaQuery");
        if (n >= this.getMediaQueryCount()) {
            this.m_aMediaQueries.add(cSSMediaQuery);
        } else {
            this.m_aMediaQueries.add(n, cSSMediaQuery);
        }
        return this;
    }

    @Nonnull
    public EChange removeMediaQuery(@Nullable CSSMediaQuery cSSMediaQuery) {
        return EChange.valueOf((boolean)this.m_aMediaQueries.remove(cSSMediaQuery));
    }

    @Nonnull
    public EChange removeMediaQuery(int n) {
        if (n < 0 || n >= this.m_aMediaQueries.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMediaQueries.remove(n);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllMediaQueries() {
        if (this.m_aMediaQueries.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMediaQueries.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSMediaQuery> getAllMediaQueries() {
        return CollectionHelper.newList(this.m_aMediaQueries);
    }

    @Nonnull
    public CSSURI getLocation() {
        return this.m_aLocation;
    }

    @Nonnull
    @Nonempty
    public String getLocationString() {
        return this.m_aLocation.getURI();
    }

    @Nonnull
    public CSSImportRule setLocation(@Nonnull CSSURI cSSURI) {
        ValueEnforcer.notNull((Object)cSSURI, (String)"Location");
        this.m_aLocation = cSSURI;
        return this;
    }

    @Nonnull
    public CSSImportRule setLocationString(@Nonnull String string) {
        this.m_aLocation.setURI(string);
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@import ").append(this.m_aLocation.getAsCSSString(iCSSWriterSettings, n));
        if (!this.m_aMediaQueries.isEmpty()) {
            stringBuilder.append(' ');
            boolean bl2 = true;
            for (CSSMediaQuery cSSMediaQuery : this.m_aMediaQueries) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(bl ? "," : ", ");
                }
                stringBuilder.append(cSSMediaQuery.getAsCSSString(iCSSWriterSettings, n));
            }
        }
        return stringBuilder.append(";\n").toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSImportRule cSSImportRule = (CSSImportRule)object;
        return this.m_aLocation.equals(cSSImportRule.m_aLocation) && this.m_aMediaQueries.equals(cSSImportRule.m_aMediaQueries);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aLocation).append(this.m_aMediaQueries).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("location", (Object)this.m_aLocation).append("mediaQueries", this.m_aMediaQueries).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

