/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.utils;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.compare.ComparatorStringLongestFirst;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.css.ECSSUnit;
import com.helger.css.propertyvalue.CSSSimpleValueWithUnit;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSNumberHelper {
    private static final Map<String, ECSSUnit> s_aNameToUnitMap;
    private static final CSSNumberHelper s_aInstance;

    private CSSNumberHelper() {
    }

    @Nullable
    public static ECSSUnit getMatchingUnitInclPercentage(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"CSSValue");
        for (Map.Entry<String, ECSSUnit> entry : s_aNameToUnitMap.entrySet()) {
            if (!string.endsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public static ECSSUnit getMatchingUnitExclPercentage(@Nonnull String string) {
        ECSSUnit eCSSUnit = CSSNumberHelper.getMatchingUnitInclPercentage(string);
        return eCSSUnit == null || eCSSUnit == ECSSUnit.PERCENTAGE ? null : eCSSUnit;
    }

    public static boolean isNumberValue(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        return StringHelper.hasText((String)string2) && StringParser.isDouble((String)string2);
    }

    public static boolean isValueWithUnit(@Nullable String string) {
        return CSSNumberHelper.isValueWithUnit(string, true);
    }

    public static boolean isValueWithUnit(@Nullable String string, boolean bl) {
        return CSSNumberHelper.getValueWithUnit(string, bl) != null;
    }

    @Nullable
    public static CSSSimpleValueWithUnit getValueWithUnit(@Nullable String string) {
        return CSSNumberHelper.getValueWithUnit(string, true);
    }

    @Nullable
    public static CSSSimpleValueWithUnit getValueWithUnit(@Nullable String string, boolean bl) {
        String string2 = StringHelper.trim((String)string);
        if (StringHelper.hasText((String)string2)) {
            BigDecimal bigDecimal;
            ECSSUnit eCSSUnit;
            if (string2.equals("0")) {
                return new CSSSimpleValueWithUnit(BigDecimal.ZERO, ECSSUnit.PX);
            }
            ECSSUnit eCSSUnit2 = eCSSUnit = bl ? CSSNumberHelper.getMatchingUnitInclPercentage(string2) : CSSNumberHelper.getMatchingUnitExclPercentage(string2);
            if (eCSSUnit != null && (bigDecimal = StringParser.parseBigDecimal((String)(string2 = string2.substring(0, string2.length() - eCSSUnit.getName().length()).trim()))) != null) {
                return new CSSSimpleValueWithUnit(bigDecimal, eCSSUnit);
            }
        }
        return null;
    }

    static {
        HashMap<String, ECSSUnit> hashMap = new HashMap<String, ECSSUnit>();
        for (ECSSUnit eCSSUnit : ECSSUnit.values()) {
            hashMap.put(eCSSUnit.getName(), eCSSUnit);
        }
        s_aNameToUnitMap = ContainerHelper.getSortedByKey(hashMap, (Comparator)new ComparatorStringLongestFirst());
        s_aInstance = new CSSNumberHelper();
    }
}

