/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.utils;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.css.decl.CSSHSL;
import com.helger.css.decl.CSSHSLA;
import com.helger.css.decl.CSSRGB;
import com.helger.css.decl.CSSRGBA;
import com.helger.css.utils.ECSSColor;
import com.helger.css.utils.ECSSColorName;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSColorHelper {
    public static final int RGB_MIN = 0;
    public static final int RGB_MAX = 255;
    public static final int RGB_RANGE = 256;
    public static final int HSL_MIN = 0;
    public static final int HSL_MAX = 359;
    public static final int HSL_RANGE = 360;
    public static final int PERCENTAGE_MIN = 0;
    public static final int PERCENTAGE_MAX = 100;
    public static final float OPACITY_MIN = 0.0f;
    public static final float OPACITY_MAX = 1.0f;
    @RegEx
    private static final String PATTERN_PART_VALUE = "((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)";
    @RegEx
    private static final String PATTERN_PART_PERCENTAGE = "((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))";
    @RegEx
    private static final String PATTERN_PART_OPACITY = "([0-9]*\\.[0-9]*|[0-9]+)";
    @RegEx
    private static final String PATTERN_RGB = "^rgb\\s*\\(\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*\\)$";
    @RegEx
    private static final String PATTERN_RGBA = "^rgba\\s*\\(\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*([0-9]*\\.[0-9]*|[0-9]+)\\s*\\)$";
    @RegEx
    private static final String PATTERN_HSL = "^hsl\\s*\\(\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))\\s*,\\s*((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))\\s*\\)$";
    @RegEx
    private static final String PATTERN_HSLA = "^hsla\\s*\\(\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))\\s*,\\s*((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))\\s*,\\s*([0-9]*\\.[0-9]*|[0-9]+)\\s*\\)$";
    @RegEx
    private static final String PATTERN_HEX = "^#[0-9a-fA-F]{1,6}$";
    private static final CSSColorHelper s_aInstance = new CSSColorHelper();

    private CSSColorHelper() {
    }

    public static boolean isColorValue(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        if (StringHelper.hasNoText((String)string2)) {
            return false;
        }
        return CSSColorHelper.isRGBColorValue(string2) || CSSColorHelper.isRGBAColorValue(string2) || CSSColorHelper.isHSLColorValue(string2) || CSSColorHelper.isHSLAColorValue(string2) || CSSColorHelper.isHexColorValue(string2) || ECSSColor.isDefaultColorName(string2) || ECSSColorName.isDefaultColorName(string2) || string2.equals("currentColor") || string2.equals("transparent");
    }

    public static boolean isRGBColorValue(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        return StringHelper.hasText((String)string2) && RegExHelper.stringMatchesPattern((String)PATTERN_RGB, (String)string2);
    }

    @Nullable
    public static CSSRGB getParsedRGBColorValue(@Nullable String string) {
        String[] stringArray;
        String string2 = StringHelper.trim((String)string);
        if (StringHelper.hasText((String)string2) && (stringArray = RegExHelper.getAllMatchingGroupValues((String)PATTERN_RGB, (String)string2)) != null) {
            return new CSSRGB(stringArray[0], stringArray[1], stringArray[2]);
        }
        return null;
    }

    public static boolean isRGBAColorValue(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        return StringHelper.hasText((String)string2) && RegExHelper.stringMatchesPattern((String)PATTERN_RGBA, (String)string2);
    }

    @Nullable
    public static CSSRGBA getParsedRGBAColorValue(@Nullable String string) {
        String[] stringArray;
        String string2 = StringHelper.trim((String)string);
        if (StringHelper.hasText((String)string2) && (stringArray = RegExHelper.getAllMatchingGroupValues((String)PATTERN_RGBA, (String)string2)) != null) {
            return new CSSRGBA(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        }
        return null;
    }

    public static boolean isHSLColorValue(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        return StringHelper.hasText((String)string2) && RegExHelper.stringMatchesPattern((String)PATTERN_HSL, (String)string2);
    }

    @Nullable
    public static CSSHSL getParsedHSLColorValue(@Nullable String string) {
        String[] stringArray;
        String string2 = StringHelper.trim((String)string);
        if (StringHelper.hasText((String)string2) && (stringArray = RegExHelper.getAllMatchingGroupValues((String)PATTERN_HSL, (String)string2)) != null) {
            return new CSSHSL(stringArray[0], stringArray[1], stringArray[2]);
        }
        return null;
    }

    public static boolean isHSLAColorValue(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        return StringHelper.hasText((String)string2) && RegExHelper.stringMatchesPattern((String)PATTERN_HSLA, (String)string2);
    }

    @Nullable
    public static CSSHSLA getParsedHSLAColorValue(@Nullable String string) {
        String[] stringArray;
        String string2 = StringHelper.trim((String)string);
        if (StringHelper.hasText((String)string2) && (stringArray = RegExHelper.getAllMatchingGroupValues((String)PATTERN_HSLA, (String)string2)) != null) {
            return new CSSHSLA(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        }
        return null;
    }

    public static boolean isHexColorValue(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        return StringHelper.hasText((String)string2) && RegExHelper.stringMatchesPattern((String)PATTERN_HEX, (String)string2);
    }

    @Nonnegative
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    private static int _mod(int n, int n2) {
        int n3;
        for (n3 = n; n3 < 0; n3 += n2) {
        }
        return n3 % n2;
    }

    @Nonnegative
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    private static float _mod(float f, int n) {
        float f2;
        for (f2 = f; f2 < 0.0f; f2 += (float)n) {
        }
        return f2 % (float)n;
    }

    @Nonnegative
    public static int getRGBValue(int n) {
        return CSSColorHelper._mod(n, 256);
    }

    @Nonnegative
    public static float getOpacityToUse(float f) {
        return f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
    }

    @Nonnull
    @Nonempty
    public static String getRGBColorValue(int n, int n2, int n3) {
        return new StringBuilder(16).append("rgb(").append(CSSColorHelper.getRGBValue(n)).append(',').append(CSSColorHelper.getRGBValue(n2)).append(',').append(CSSColorHelper.getRGBValue(n3)).append(")").toString();
    }

    @Nonnull
    @Nonempty
    public static String getRGBAColorValue(int n, int n2, int n3, float f) {
        return new StringBuilder(24).append("rgba(").append(CSSColorHelper.getRGBValue(n)).append(',').append(CSSColorHelper.getRGBValue(n2)).append(',').append(CSSColorHelper.getRGBValue(n3)).append(',').append(CSSColorHelper.getOpacityToUse(f)).append(")").toString();
    }

    @Nonnegative
    public static int getHSLHueValue(int n) {
        return CSSColorHelper._mod(n, 360);
    }

    @Nonnegative
    public static float getHSLHueValue(float f) {
        return CSSColorHelper._mod(f, 360);
    }

    @Nonnegative
    public static int getHSLPercentageValue(int n) {
        return n < 0 ? 0 : (n > 100 ? 100 : n);
    }

    @Nonnegative
    public static float getHSLPercentageValue(float f) {
        return f < 0.0f ? 0.0f : (f > 100.0f ? 100.0f : f);
    }

    @Nonnull
    @Nonempty
    public static String getHSLColorValue(int n, int n2, int n3) {
        return new StringBuilder(18).append("hsl(").append(CSSColorHelper.getHSLHueValue(n)).append(',').append(CSSColorHelper.getHSLPercentageValue(n2)).append("%,").append(CSSColorHelper.getHSLPercentageValue(n3)).append("%").append(")").toString();
    }

    @Nonnull
    @Nonempty
    public static String getHSLColorValue(float f, float f2, float f3) {
        return new StringBuilder(18).append("hsl(").append(CSSColorHelper.getHSLHueValue(f)).append(',').append(CSSColorHelper.getHSLPercentageValue(f2)).append("%,").append(CSSColorHelper.getHSLPercentageValue(f3)).append("%").append(")").toString();
    }

    @Nonnull
    @Nonempty
    public static String getHSLAColorValue(int n, int n2, int n3, float f) {
        return new StringBuilder(32).append("hsla(").append(CSSColorHelper.getHSLHueValue(n)).append(',').append(CSSColorHelper.getHSLPercentageValue(n2)).append("%,").append(CSSColorHelper.getHSLPercentageValue(n3)).append("%,").append(CSSColorHelper.getOpacityToUse(f)).append(")").toString();
    }

    @Nonnull
    @Nonempty
    public static String getHSLAColorValue(float f, float f2, float f3, float f4) {
        return new StringBuilder(32).append("hsla(").append(CSSColorHelper.getHSLHueValue(f)).append(',').append(CSSColorHelper.getHSLPercentageValue(f2)).append("%,").append(CSSColorHelper.getHSLPercentageValue(f3)).append("%,").append(CSSColorHelper.getOpacityToUse(f4)).append(")").toString();
    }

    @Nonnull
    @Nonempty
    private static String _getRGBPartAsHexString(int n) {
        return StringHelper.getHexStringLeadingZero((int)CSSColorHelper.getRGBValue(n), (int)2);
    }

    @Nonnull
    @Nonempty
    public static String getHexColorValue(int n, int n2, int n3) {
        return new StringBuilder(7).append('#').append(CSSColorHelper._getRGBPartAsHexString(n)).append(CSSColorHelper._getRGBPartAsHexString(n2)).append(CSSColorHelper._getRGBPartAsHexString(n3)).toString();
    }

    @Nonnull
    @Nonempty
    public static float[] getRGBAsHSLValue(int n, int n2, int n3) {
        float[] fArray = Color.RGBtoHSB(n, n2, n3, new float[3]);
        return new float[]{fArray[0] * 359.0f, fArray[1] * 100.0f, fArray[2] * 100.0f};
    }

    @Nonnull
    @Nonempty
    public static int[] getHSLAsRGBValue(float f, float f2, float f3) {
        int n = Color.HSBtoRGB(f / 359.0f, f2 / 100.0f, f3 / 100.0f);
        return new int[]{n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF};
    }
}

