/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.parser;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.parser.Token;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ReadonlyToken {
    private final int m_nKind;
    private final int m_nBeginLine;
    private final int m_nBeginColumn;
    private final int m_nEndLine;
    private final int m_nEndColumn;
    private final String m_sImage;

    public ReadonlyToken(@Nonnull Token token) {
        ValueEnforcer.notNull((Object)token, (String)"Token");
        this.m_nKind = token.kind;
        this.m_nBeginLine = token.beginLine;
        this.m_nBeginColumn = token.beginColumn;
        this.m_nEndLine = token.endLine;
        this.m_nEndColumn = token.endColumn;
        this.m_sImage = token.image;
    }

    public int getKind() {
        return this.m_nKind;
    }

    public int getBeginLine() {
        return this.m_nBeginLine;
    }

    public int getBeginColumn() {
        return this.m_nBeginColumn;
    }

    public int getEndLine() {
        return this.m_nEndLine;
    }

    public int getEndColumn() {
        return this.m_nEndColumn;
    }

    @Nullable
    public String getImage() {
        return this.m_sImage;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("kind", this.m_nKind).append("beginLine", this.m_nBeginLine).append("beginColumn", this.m_nBeginColumn).append("endLine", this.m_nEndLine).append("endColumn", this.m_nEndColumn).append("image", (Object)this.m_sImage).toString();
    }
}

