/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ECSSVersion;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.ICSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import com.helger.css.propertyvalue.CSSValue;
import com.helger.css.propertyvalue.ICSSValue;
import com.helger.css.utils.ICSSNamedColor;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractCSSProperty
implements ICSSProperty {
    private final ECSSProperty m_eProp;
    private final ICSSPropertyCustomizer m_aCustomizer;

    protected AbstractCSSProperty(@Nonnull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer) {
        this.m_eProp = (ECSSProperty)ValueEnforcer.notNull((Object)eCSSProperty, (String)"Property");
        this.m_aCustomizer = iCSSPropertyCustomizer;
    }

    @Override
    @Nonnull
    public final ECSSVersion getMinimumCSSVersion() {
        return this.m_eProp.getMinimumCSSVersion();
    }

    @Override
    @Nonnull
    public final ECSSProperty getProp() {
        return this.m_eProp;
    }

    @Override
    @Nullable
    public final ICSSPropertyCustomizer getCustomizer() {
        return this.m_aCustomizer;
    }

    @Override
    @Nonnegative
    @OverrideOnDemand
    public int getMinimumArgumentCount() {
        return 1;
    }

    @Override
    @Nonnegative
    @OverrideOnDemand
    public int getMaximumArgumentCount() {
        return 1;
    }

    public static boolean isValidPropertyValue(@Nullable String string) {
        return "inherit".equals(string) || "initial".equals(string);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String string) {
        return AbstractCSSProperty.isValidPropertyValue(string);
    }

    @Override
    @Nonnull
    public ICSSValue newValue(@Nonnull @Nonempty String string, boolean bl) {
        ICSSValue iCSSValue;
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Value");
        if (this.m_aCustomizer != null && (iCSSValue = this.m_aCustomizer.createSpecialValue(this, string, bl)) != null) {
            return iCSSValue;
        }
        return new CSSValue(this, string, bl);
    }

    @Override
    @Nonnull
    public final ICSSValue newValue(@Nonnull @Nonempty String string) {
        return this.newValue(string, false);
    }

    @Override
    @Nonnull
    public final ICSSValue newImportantValue(@Nonnull @Nonempty String string) {
        return this.newValue(string, true);
    }

    @Override
    @Nonnull
    public final ICSSValue newValue(@Nonnull ICSSNamedColor iCSSNamedColor, boolean bl) {
        return this.newValue(iCSSNamedColor.getName(), bl);
    }

    @Override
    @Nonnull
    public final ICSSValue newValue(@Nonnull ICSSNamedColor iCSSNamedColor) {
        return this.newValue(iCSSNamedColor.getName());
    }

    @Override
    @Nonnull
    public final ICSSValue newImportantValue(@Nonnull ICSSNamedColor iCSSNamedColor) {
        return this.newImportantValue(iCSSNamedColor.getName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractCSSProperty abstractCSSProperty = (AbstractCSSProperty)object;
        return this.m_eProp.equals(abstractCSSProperty.m_eProp);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eProp).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("prop", (Enum)this.m_eProp).toString();
    }
}

