/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.writer;

import com.helger.commons.ValueEnforcer;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.reader.CSSReader;
import com.helger.css.writer.CSSWriter;
import com.helger.css.writer.CSSWriterSettings;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CSSCompressor {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSCompressor.class);
    private static final CSSCompressor s_aInstance = new CSSCompressor();

    private CSSCompressor() {
    }

    @Nonnull
    public static String getCompressedCSS(@Nonnull String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSCompressor.getCompressedCSS(string, charset, eCSSVersion, false);
    }

    @Nonnull
    public static String getCompressedCSS(@Nonnull String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, boolean bl) {
        CSSWriterSettings cSSWriterSettings = new CSSWriterSettings(eCSSVersion, true);
        cSSWriterSettings.setRemoveUnnecessaryCode(bl);
        return CSSCompressor.getRewrittenCSS(string, charset, cSSWriterSettings);
    }

    @Nonnull
    @Deprecated
    public static String getRewrittenCSS(@Nonnull String string, @Nonnull Charset charset, @Nonnull CSSWriterSettings cSSWriterSettings) {
        return CSSCompressor.getRewrittenCSS(string, cSSWriterSettings);
    }

    @Nonnull
    public static String getRewrittenCSS(@Nonnull String string, @Nonnull CSSWriterSettings cSSWriterSettings) {
        ValueEnforcer.notNull((Object)string, (String)"OriginalCSS");
        ValueEnforcer.notNull((Object)cSSWriterSettings, (String)"Settings");
        CascadingStyleSheet cascadingStyleSheet = CSSReader.readFromString(string, cSSWriterSettings.getVersion());
        if (cascadingStyleSheet != null) {
            try {
                return new CSSWriter(cSSWriterSettings).getCSSAsString(cascadingStyleSheet);
            }
            catch (Exception exception) {
                s_aLogger.warn("Failed to write optimized CSS!", (Throwable)exception);
            }
        }
        return string;
    }
}

