/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.IHasCSSDeclarations;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSDeclarationList
implements IHasCSSDeclarations,
ICSSSourceLocationAware {
    private final List<CSSDeclaration> m_aDeclarations = new ArrayList<CSSDeclaration>();
    private CSSSourceLocation m_aSourceLocation;

    @Override
    @Nonnull
    public final CSSDeclarationList addDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        ValueEnforcer.notNull((Object)cSSDeclaration, (String)"NewDeclaration");
        this.m_aDeclarations.add(cSSDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public final CSSDeclarationList addDeclaration(@Nonnull @Nonempty String string, @Nonnull CSSExpression cSSExpression, boolean bl) {
        return this.addDeclaration(new CSSDeclaration(string, cSSExpression, bl));
    }

    @Override
    @Nonnull
    public CSSDeclarationList addDeclaration(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSDeclaration, (String)"NewDeclaration");
        if (n >= this.getDeclarationCount()) {
            this.m_aDeclarations.add(cSSDeclaration);
        } else {
            this.m_aDeclarations.add(n, cSSDeclaration);
        }
        return this;
    }

    @Override
    @Nonnull
    public final EChange removeDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        return EChange.valueOf((boolean)this.m_aDeclarations.remove(cSSDeclaration));
    }

    @Override
    @Nonnull
    public final EChange removeDeclaration(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aDeclarations.size()) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf((this.m_aDeclarations.remove(n) != null ? 1 : 0) != 0);
    }

    @Override
    @Nonnull
    public EChange removeAllDeclarations() {
        if (this.m_aDeclarations.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aDeclarations.clear();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final List<CSSDeclaration> getAllDeclarations() {
        return ContainerHelper.newList(this.m_aDeclarations);
    }

    @Override
    @Nullable
    public final CSSDeclaration getDeclarationAtIndex(@Nonnegative int n) {
        return (CSSDeclaration)ContainerHelper.getSafe(this.m_aDeclarations, (int)n);
    }

    @Override
    @Nonnull
    public CSSDeclarationList setDeclarationAtIndex(@Nonnegative int n, @Nonnull CSSDeclaration cSSDeclaration) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSDeclaration, (String)"NewDeclaration");
        if (n >= this.getDeclarationCount()) {
            this.m_aDeclarations.add(cSSDeclaration);
        } else {
            this.m_aDeclarations.set(n, cSSDeclaration);
        }
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return !this.m_aDeclarations.isEmpty();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.size();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyName(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            for (CSSDeclaration cSSDeclaration : this.m_aDeclarations) {
                if (!cSSDeclaration.getProperty().equals(string)) continue;
                return cSSDeclaration;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyNameCaseInsensitive(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            for (CSSDeclaration cSSDeclaration : this.m_aDeclarations) {
                if (!cSSDeclaration.getProperty().equalsIgnoreCase(string)) continue;
                return cSSDeclaration;
            }
        }
        return null;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String string) {
        ArrayList<CSSDeclaration> arrayList = new ArrayList<CSSDeclaration>();
        if (StringHelper.hasText((String)string)) {
            for (CSSDeclaration cSSDeclaration : this.m_aDeclarations) {
                if (!cSSDeclaration.getProperty().equals(string)) continue;
                arrayList.add(cSSDeclaration);
            }
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSDeclaration> getAllDeclarationsOfPropertyNameCaseInsensitive(@Nullable String string) {
        ArrayList<CSSDeclaration> arrayList = new ArrayList<CSSDeclaration>();
        if (StringHelper.hasText((String)string)) {
            for (CSSDeclaration cSSDeclaration : this.m_aDeclarations) {
                if (!cSSDeclaration.getProperty().equalsIgnoreCase(string)) continue;
                arrayList.add(cSSDeclaration);
            }
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        int n2 = this.m_aDeclarations.size();
        if (n2 == 0) {
            return "";
        }
        if (n2 == 1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(((CSSDeclaration)ContainerHelper.getFirstElement(this.m_aDeclarations)).getAsCSSString(iCSSWriterSettings, n));
            if (!bl) {
                stringBuilder.append(';');
            }
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        for (CSSDeclaration cSSDeclaration : this.m_aDeclarations) {
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n + 1));
            }
            stringBuilder.append(cSSDeclaration.getAsCSSString(iCSSWriterSettings, n + 1));
            if (!bl || n3 < n2 - 1) {
                stringBuilder.append(';');
            }
            if (!bl) {
                stringBuilder.append('\n');
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSDeclarationList cSSDeclarationList = (CSSDeclarationList)object;
        return this.m_aDeclarations.equals(cSSDeclarationList.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aDeclarations).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("declarations", this.m_aDeclarations).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

