/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text.resolve;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.locale.LocaleHelper;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedCounter;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.text.resolve.AbstractEnumTextResolverWithOverrideAndFallback;
import com.helger.commons.text.resourcebundle.ResourceBundleHelper;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PropertyKey;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class EnumTextResolverWithPropertiesOverrideAndFallback
extends AbstractEnumTextResolverWithOverrideAndFallback {
    public static final String PREFIX_OVERRIDE = "properties/override-";
    public static final String PREFIX_FALLBACK = "properties/";
    public static final boolean DEFAULT_USE_RESOURCE_BUNDLE_CACHE = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(EnumTextResolverWithPropertiesOverrideAndFallback.class);
    private static final IMutableStatisticsHandlerKeyedCounter s_aStatsFailed = StatisticsManager.getKeyedCounterHandler(EnumTextResolverWithPropertiesOverrideAndFallback.class.getName() + "$failed");
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<String> m_aUsedOverrideBundles = new CommonsHashSet<String>();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<String> m_aUsedFallbackBundles = new CommonsHashSet<String>();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bUseResourceBundleCache = true;
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, ResourceBundle> m_aResourceBundleCache = new CommonsHashMap<String, ResourceBundle>();

    public void setUseResourceBundleCache(boolean bl) {
        this.m_aRWLock.writeLockedBoolean(() -> {
            this.m_bUseResourceBundleCache = bl;
            return this.m_bUseResourceBundleCache;
        });
    }

    public boolean isUseResourceBundleCache() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_bUseResourceBundleCache);
    }

    @Nullable
    private ResourceBundle _getResourceBundle(@Nonnull @Nonempty String string, @Nonnull Locale locale) {
        ResourceBundle resourceBundle = this.m_aRWLock.readLockedGet(() -> {
            if (!this.m_bUseResourceBundleCache) {
                return ResourceBundleHelper.getResourceBundle(string, locale);
            }
            if (this.m_aResourceBundleCache.containsKey(string)) {
                return (ResourceBundle)this.m_aResourceBundleCache.get(string);
            }
            return null;
        });
        if (resourceBundle == null) {
            resourceBundle = this.m_aRWLock.writeLockedGet(() -> {
                if (this.m_aResourceBundleCache.containsKey(string)) {
                    return (ResourceBundle)this.m_aResourceBundleCache.get(string);
                }
                ResourceBundle resourceBundle = ResourceBundleHelper.getResourceBundle(string, locale);
                this.m_aResourceBundleCache.put(string, resourceBundle);
                return resourceBundle;
            });
        }
        return resourceBundle;
    }

    @Override
    @Nullable
    protected String internalGetOverrideString(@Nonnull @PropertyKey String string, @Nonnull Locale locale) {
        for (Locale locale2 : LocaleHelper.getCalculatedLocaleListForResolving(locale)) {
            String string2 = PREFIX_OVERRIDE + locale2.toString();
            String string3 = ResourceBundleHelper.getString(this._getResourceBundle(string2, locale2), string);
            if (string3 == null) continue;
            this.m_aRWLock.writeLockedBoolean(() -> this.m_aUsedOverrideBundles.add(string2));
            return string3;
        }
        return null;
    }

    @Override
    @Nullable
    protected String internalGetFallbackString(@Nonnull @PropertyKey String string, @Nonnull Locale locale) {
        for (Locale locale2 : LocaleHelper.getCalculatedLocaleListForResolving(locale)) {
            String string2 = PREFIX_FALLBACK + locale2.toString();
            String string3 = ResourceBundleHelper.getString(this._getResourceBundle(string2, locale2), string);
            if (string3 == null) continue;
            this.m_aRWLock.writeLockedBoolean(() -> this.m_aUsedFallbackBundles.add(string2));
            return string3;
        }
        s_aStatsFailed.increment(PREFIX_FALLBACK + locale.toString() + ':' + string);
        if (GlobalDebug.isDebugMode() && LOGGER.isWarnEnabled()) {
            LOGGER.warn("getFallbackString (" + string + "; " + locale.toString() + ") failed!");
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllUsedOverrideBundleNames() {
        return this.m_aRWLock.readLockedGet(this.m_aUsedOverrideBundles::getClone);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllUsedFallbackBundleNames() {
        return this.m_aRWLock.readLockedGet(this.m_aUsedFallbackBundles::getClone);
    }

    public void clearCache() {
        this.m_aRWLock.writeLocked(() -> {
            ResourceBundleHelper.clearCache();
            this.m_aUsedOverrideBundles.clear();
            this.m_aUsedFallbackBundles.clear();
            this.m_aResourceBundleCache.clear();
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cache was cleared: " + this.getClass().getName());
        }
    }
}

