/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.xpath;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.xml.xpath.XPathHelper;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@NotThreadSafe
public final class XPathExpressionHelper {
    private static final XPathExpressionHelper INSTANCE = new XPathExpressionHelper();

    private XPathExpressionHelper() {
    }

    public static @Nullable Object evalXPath(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext, @NonNull String string, @NonNull Document document, @NonNull QName qName) {
        return XPathExpressionHelper.evalXPath(XPathHelper.createNewXPath(xPathVariableResolver, xPathFunctionResolver, namespaceContext), string, document, qName);
    }

    public static @Nullable Object evalXPath(@NonNull XPath xPath, @NonNull @Nonempty String string, @NonNull Document document, @NonNull QName qName) {
        ValueEnforcer.notNull((Object)xPath, (String)"XPath");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"XPathExpression");
        ValueEnforcer.notNull((Object)document, (String)"Doc");
        ValueEnforcer.notNull((Object)qName, (String)"ReturnType");
        try {
            XPathExpression xPathExpression = XPathHelper.createNewXPathExpression(xPath, string);
            return xPathExpression.evaluate(document, qName);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new IllegalArgumentException("Failed to evaluate XPath expression '" + string + "' with return type " + qName.toString(), xPathExpressionException);
        }
    }

    public static @Nullable Double evalXPathToNumber(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext, @NonNull String string, @NonNull Document document) {
        return XPathExpressionHelper.evalXPathToNumber(XPathHelper.createNewXPath(xPathVariableResolver, xPathFunctionResolver, namespaceContext), string, document);
    }

    public static @Nullable Double evalXPathToNumber(@NonNull String string, @NonNull Document document) {
        return XPathExpressionHelper.evalXPathToNumber(XPathHelper.createNewXPath(), string, document);
    }

    public static @Nullable Double evalXPathToNumber(@NonNull XPath xPath, @NonNull String string, @NonNull Document document) {
        Object object = XPathExpressionHelper.evalXPath(xPath, string, document, XPathConstants.NUMBER);
        return (Double)object;
    }

    public static @Nullable String evalXPathToString(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext, @NonNull String string, @NonNull Document document) {
        return XPathExpressionHelper.evalXPathToString(XPathHelper.createNewXPath(xPathVariableResolver, xPathFunctionResolver, namespaceContext), string, document);
    }

    public static @Nullable String evalXPathToString(@NonNull String string, @NonNull Document document) {
        return XPathExpressionHelper.evalXPathToString(XPathHelper.createNewXPath(), string, document);
    }

    public static @Nullable String evalXPathToString(@NonNull XPath xPath, @NonNull String string, @NonNull Document document) {
        Object object = XPathExpressionHelper.evalXPath(xPath, string, document, XPathConstants.STRING);
        return (String)object;
    }

    public static @Nullable Boolean evalXPathToBoolean(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext, @NonNull String string, @NonNull Document document) {
        return XPathExpressionHelper.evalXPathToBoolean(XPathHelper.createNewXPath(xPathVariableResolver, xPathFunctionResolver, namespaceContext), string, document);
    }

    public static @Nullable Boolean evalXPathToBoolean(@NonNull String string, @NonNull Document document) {
        return XPathExpressionHelper.evalXPathToBoolean(XPathHelper.createNewXPath(), string, document);
    }

    public static @Nullable Boolean evalXPathToBoolean(@NonNull XPath xPath, @NonNull String string, @NonNull Document document) {
        Object object = XPathExpressionHelper.evalXPath(xPath, string, document, XPathConstants.BOOLEAN);
        return (Boolean)object;
    }

    public static @Nullable NodeList evalXPathToNodeList(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext, @NonNull String string, @NonNull Document document) {
        return XPathExpressionHelper.evalXPathToNodeList(XPathHelper.createNewXPath(xPathVariableResolver, xPathFunctionResolver, namespaceContext), string, document);
    }

    public static @Nullable NodeList evalXPathToNodeList(@NonNull String string, @NonNull Document document) {
        return XPathExpressionHelper.evalXPathToNodeList(XPathHelper.createNewXPath(), string, document);
    }

    public static @Nullable NodeList evalXPathToNodeList(@NonNull XPath xPath, @NonNull String string, @NonNull Document document) {
        Object object = XPathExpressionHelper.evalXPath(xPath, string, document, XPathConstants.NODESET);
        return (NodeList)object;
    }

    public static @Nullable Node evalXPathToNode(@Nullable XPathVariableResolver xPathVariableResolver, @Nullable XPathFunctionResolver xPathFunctionResolver, @Nullable NamespaceContext namespaceContext, @NonNull String string, @NonNull Document document) {
        return XPathExpressionHelper.evalXPathToNode(XPathHelper.createNewXPath(xPathVariableResolver, xPathFunctionResolver, namespaceContext), string, document);
    }

    public static @Nullable Node evalXPathToNode(@NonNull String string, @NonNull Document document) {
        return XPathExpressionHelper.evalXPathToNode(XPathHelper.createNewXPath(), string, document);
    }

    public static @Nullable Node evalXPathToNode(@NonNull XPath xPath, @NonNull String string, @NonNull Document document) {
        Object object = XPathExpressionHelper.evalXPath(xPath, string, document, XPathConstants.NODE);
        return (Node)object;
    }
}

