/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.util.mime;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.CommonsTreeMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.collection.commons.ICommonsSet;
import com.helger.io.file.FilenameHelper;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.IReadableResource;
import com.helger.mime.IMimeType;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.util.mime.MimeTypeInfo;
import java.io.File;
import java.util.Comparator;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@ThreadSafe
public class MimeTypeInfoManager {
    public static final String MIME_TYPE_INFO_XML = "codelists/mime-type-info.xml";
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<MimeTypeInfo> m_aList = new CommonsArrayList();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<IMimeType, ICommonsList<MimeTypeInfo>> m_aMapMimeType = new CommonsTreeMap();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, ICommonsList<MimeTypeInfo>> m_aMapExt = new CommonsTreeMap();

    public static boolean isDefaultInstantiated() {
        return s_bDefaultInstantiated;
    }

    public static @NonNull MimeTypeInfoManager getDefaultInstance() {
        MimeTypeInfoManager mimeTypeInfoManager = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return mimeTypeInfoManager;
    }

    public @NonNull MimeTypeInfoManager readDefault() {
        return this.read((IReadableResource)new ClassPathResource(MIME_TYPE_INFO_XML));
    }

    public @NonNull MimeTypeInfoManager read(@NonNull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        IMicroDocument iMicroDocument = MicroReader.readMicroXML(iReadableResource);
        if (iMicroDocument == null) {
            throw new IllegalArgumentException("Failed to read MimeTypeInfo resource " + String.valueOf(iReadableResource));
        }
        iMicroDocument.getDocumentElement().forAllChildElements(iMicroElement -> {
            MimeTypeInfo mimeTypeInfo = MicroTypeConverter.convertToNative(iMicroElement, MimeTypeInfo.class);
            this.registerMimeType(mimeTypeInfo);
        });
        return this;
    }

    public @NonNull EChange clearCache() {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            EChange eChange = this.m_aList.removeAll();
            if (!this.m_aMapExt.isEmpty()) {
                this.m_aMapExt.clear();
                eChange = EChange.CHANGED;
            }
            if (!this.m_aMapMimeType.isEmpty()) {
                this.m_aMapMimeType.clear();
                eChange = EChange.CHANGED;
            }
            return eChange;
        });
    }

    public void reinitializeToDefault() {
        this.clearCache();
        this.readDefault();
    }

    @ReturnsMutableCopy
    public @NonNull IMicroDocument getAsDocument() {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.addElement("mime-type-info");
        this.m_aRWLock.readLocked(() -> {
            for (MimeTypeInfo mimeTypeInfo : this.m_aList.getSorted(Comparator.comparing(MimeTypeInfo::getPrimaryMimeTypeString))) {
                iMicroElement.addChild(MicroTypeConverter.convertToMicroElement(mimeTypeInfo, "item"));
            }
        });
        return microDocument;
    }

    public void registerMimeType(@NonNull MimeTypeInfo mimeTypeInfo) {
        ValueEnforcer.notNull((Object)mimeTypeInfo, (String)"Info");
        ICommonsSet<MimeTypeInfo.MimeTypeWithSource> iCommonsSet = mimeTypeInfo.getAllMimeTypesWithSource();
        ICommonsOrderedSet<MimeTypeInfo.ExtensionWithSource> iCommonsOrderedSet = mimeTypeInfo.getAllExtensionsWithSource();
        this.m_aRWLock.readLocked(() -> {
            for (MimeTypeInfo.MimeTypeWithSource mimeTypeWithSource : iCommonsSet) {
                ICommonsList iCommonsList = (ICommonsList)this.m_aMapMimeType.get((Object)mimeTypeWithSource.getMimeType());
                if (iCommonsList == null) continue;
                throw new IllegalArgumentException("Cannot register " + String.valueOf(mimeTypeInfo) + ". A mapping for mime type '" + String.valueOf(mimeTypeWithSource) + "' is already registered: " + String.valueOf(iCommonsList));
            }
        });
        this.m_aRWLock.writeLocked(() -> {
            this.m_aList.add((Object)mimeTypeInfo);
            for (Object object : iCommonsSet) {
                ((ICommonsList)this.m_aMapMimeType.computeIfAbsent((Object)((MimeTypeInfo.MimeTypeWithSource)object).getMimeType(), iMimeType -> new CommonsArrayList())).add((Object)mimeTypeInfo);
            }
            for (Object object : iCommonsOrderedSet) {
                ((ICommonsList)this.m_aMapExt.computeIfAbsent((Object)((MimeTypeInfo.ExtensionWithSource)object).getExtension(), string -> new CommonsArrayList())).add((Object)mimeTypeInfo);
            }
        });
    }

    public final void addExtension(@NonNull MimeTypeInfo mimeTypeInfo, @NonNull MimeTypeInfo.ExtensionWithSource extensionWithSource) {
        ValueEnforcer.notNull((Object)mimeTypeInfo, (String)"Info");
        ValueEnforcer.notNull((Object)extensionWithSource, (String)"Ext");
        this.m_aRWLock.writeLocked(() -> {
            ((ICommonsList)this.m_aMapExt.computeIfAbsent((Object)extensionWithSource.getExtension(), string -> new CommonsArrayList())).add((Object)mimeTypeInfo);
            mimeTypeInfo.addExtension(extensionWithSource);
        });
    }

    public final void addMimeType(@NonNull MimeTypeInfo mimeTypeInfo, @NonNull MimeTypeInfo.MimeTypeWithSource mimeTypeWithSource) {
        ValueEnforcer.notNull((Object)mimeTypeInfo, (String)"Info");
        ValueEnforcer.notNull((Object)mimeTypeWithSource, (String)"MimeType");
        this.m_aRWLock.writeLocked(() -> {
            ((ICommonsList)this.m_aMapMimeType.computeIfAbsent((Object)mimeTypeWithSource.getMimeType(), iMimeType -> new CommonsArrayList())).add((Object)mimeTypeInfo);
            mimeTypeInfo.addMimeType(mimeTypeWithSource);
        });
    }

    @ReturnsMutableCopy
    public @Nullable ICommonsList<MimeTypeInfo> getAllInfosOfFilename(@Nullable File file) {
        if (file == null) {
            return null;
        }
        String string = FilenameHelper.getExtension((File)file);
        return this.getAllInfosOfExtension(string);
    }

    @ReturnsMutableCopy
    public @Nullable ICommonsList<MimeTypeInfo> getAllInfosOfFilename(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        String string2 = FilenameHelper.getExtension((String)string);
        return this.getAllInfosOfExtension(string2);
    }

    @ReturnsMutableCopy
    public @Nullable ICommonsList<MimeTypeInfo> getAllInfosOfExtension(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> {
            ICommonsList iCommonsList = (ICommonsList)this.m_aMapExt.get((Object)string);
            if (iCommonsList == null) {
                iCommonsList = (ICommonsList)this.m_aMapExt.get((Object)string.toLowerCase(Locale.US));
            }
            return iCommonsList == null ? null : (ICommonsList)iCommonsList.getClone();
        });
    }

    @ReturnsMutableCopy
    public @Nullable ICommonsList<MimeTypeInfo> getAllInfosOfMimeType(@Nullable IMimeType iMimeType) {
        if (iMimeType == null) {
            return null;
        }
        ICommonsList iCommonsList = (ICommonsList)this.m_aRWLock.readLockedGet(() -> (ICommonsList)this.m_aMapMimeType.get((Object)iMimeType));
        return iCommonsList == null ? null : (ICommonsList)iCommonsList.getClone();
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<MimeTypeInfo> getAllMimeTypeInfos() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aList.getClone());
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedSet<IMimeType> getAllMimeTypes() {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        this.m_aRWLock.readLocked(() -> this.lambda$getAllMimeTypes$14((ICommonsOrderedSet)commonsLinkedHashSet));
        return commonsLinkedHashSet;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedSet<String> getAllMimeTypeStrings() {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        this.m_aRWLock.readLocked(() -> this.lambda$getAllMimeTypeStrings$16((ICommonsOrderedSet)commonsLinkedHashSet));
        return commonsLinkedHashSet;
    }

    public boolean containsMimeTypeForFilename(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Filename");
        String string2 = FilenameHelper.getExtension((String)string);
        return this.containsMimeTypeForExtension(string2);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsSet<IMimeType> getAllMimeTypesForFilename(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Filename");
        String string2 = FilenameHelper.getExtension((String)string);
        return this.getAllMimeTypesForExtension(string2);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsSet<String> getAllMimeTypeStringsForFilename(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Filename");
        String string2 = FilenameHelper.getExtension((String)string);
        return this.getAllMimeTypeStringsForExtension(string2);
    }

    public @Nullable IMimeType getPrimaryMimeTypeForFilename(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Filename");
        String string2 = FilenameHelper.getExtension((String)string);
        return this.getPrimaryMimeTypeForExtension(string2);
    }

    public @Nullable String getPrimaryMimeTypeStringForFilename(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Filename");
        String string2 = FilenameHelper.getExtension((String)string);
        return this.getPrimaryMimeTypeStringForExtension(string2);
    }

    public boolean containsMimeTypeForExtension(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Extension");
        ICommonsList<MimeTypeInfo> iCommonsList = this.getAllInfosOfExtension(string);
        return CollectionHelper.isNotEmpty(iCommonsList);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedSet<IMimeType> getAllMimeTypesForExtension(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Extension");
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        ICommonsList<MimeTypeInfo> iCommonsList = this.getAllInfosOfExtension(string);
        if (iCommonsList != null) {
            for (MimeTypeInfo mimeTypeInfo : iCommonsList) {
                commonsLinkedHashSet.addAll(mimeTypeInfo.getAllMimeTypes());
            }
        }
        return commonsLinkedHashSet;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedSet<String> getAllMimeTypeStringsForExtension(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Extension");
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        ICommonsList<MimeTypeInfo> iCommonsList = this.getAllInfosOfExtension(string);
        if (iCommonsList != null) {
            for (MimeTypeInfo mimeTypeInfo : iCommonsList) {
                commonsLinkedHashSet.addAll(mimeTypeInfo.getAllMimeTypeStrings());
            }
        }
        return commonsLinkedHashSet;
    }

    public @Nullable IMimeType getPrimaryMimeTypeForExtension(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Extension");
        ICommonsList<MimeTypeInfo> iCommonsList = this.getAllInfosOfExtension(string);
        if (iCommonsList != null && iCommonsList.isNotEmpty()) {
            return ((MimeTypeInfo)iCommonsList.getFirstOrNull()).getPrimaryMimeType();
        }
        return null;
    }

    public @Nullable String getPrimaryMimeTypeStringForExtension(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Extension");
        ICommonsList<MimeTypeInfo> iCommonsList = this.getAllInfosOfExtension(string);
        if (iCommonsList != null && iCommonsList.isNotEmpty()) {
            return ((MimeTypeInfo)iCommonsList.getFirstOrNull()).getPrimaryMimeTypeString();
        }
        return null;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedSet<String> getAllExtensionsOfMimeType(@Nullable IMimeType iMimeType) {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        ICommonsList<MimeTypeInfo> iCommonsList = this.getAllInfosOfMimeType(iMimeType);
        if (iCommonsList != null) {
            for (MimeTypeInfo mimeTypeInfo : iCommonsList) {
                commonsLinkedHashSet.addAll(mimeTypeInfo.getAllExtensions());
            }
        }
        return commonsLinkedHashSet;
    }

    public @Nullable String getPrimaryExtensionOfMimeType(@Nullable IMimeType iMimeType) {
        ICommonsList<MimeTypeInfo> iCommonsList = this.getAllInfosOfMimeType(iMimeType);
        if (iCommonsList != null) {
            for (MimeTypeInfo mimeTypeInfo : iCommonsList) {
                String string = mimeTypeInfo.getPrimaryExtension();
                if (string == null) continue;
                return string;
            }
        }
        return null;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedSet<String> getAllGlobsOfMimeType(@Nullable IMimeType iMimeType) {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        ICommonsList<MimeTypeInfo> iCommonsList = this.getAllInfosOfMimeType(iMimeType);
        if (iCommonsList != null) {
            for (MimeTypeInfo mimeTypeInfo : iCommonsList) {
                commonsLinkedHashSet.addAll(mimeTypeInfo.getAllGlobs());
            }
        }
        return commonsLinkedHashSet;
    }

    private /* synthetic */ void lambda$getAllMimeTypeStrings$16(ICommonsOrderedSet iCommonsOrderedSet) {
        this.m_aList.forEach(mimeTypeInfo -> iCommonsOrderedSet.addAll(mimeTypeInfo.getAllMimeTypeStrings()));
    }

    private /* synthetic */ void lambda$getAllMimeTypes$14(ICommonsOrderedSet iCommonsOrderedSet) {
        this.m_aList.forEach(mimeTypeInfo -> iCommonsOrderedSet.addAll(mimeTypeInfo.getAllMimeTypes()));
    }

    private static final class SingletonHolder {
        private static final MimeTypeInfoManager INSTANCE = new MimeTypeInfoManager().readDefault();

        private SingletonHolder() {
        }
    }
}

