/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.write;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillNotClose;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingBufferedWriter;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.xml.XMLHelper;
import com.helger.xml.namespace.IIterableNamespaceContext;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLEmitter;
import java.io.Flushable;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXMLSerializer<NODETYPE> {
    public static final String DEFAULT_NAMESPACE_PREFIX_PREFIX = "ns";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractXMLSerializer.class);
    protected final IXMLWriterSettings m_aSettings;
    protected final StringBuilder m_aIndent = new StringBuilder(32);
    protected final NamespaceStack m_aNSStack;
    private final ICommonsOrderedMap<String, String> m_aRootNSMap = new CommonsLinkedHashMap();

    protected AbstractXMLSerializer(@NonNull IXMLWriterSettings iXMLWriterSettings) {
        this.m_aSettings = (IXMLWriterSettings)ValueEnforcer.notNull((Object)iXMLWriterSettings, (String)"Settings");
        NamespaceContext namespaceContext = iXMLWriterSettings.getNamespaceContext();
        this.m_aNSStack = new NamespaceStack(namespaceContext);
        if (iXMLWriterSettings.isPutNamespaceContextPrefixesInRoot()) {
            if (namespaceContext instanceof IIterableNamespaceContext) {
                IIterableNamespaceContext iIterableNamespaceContext = (IIterableNamespaceContext)namespaceContext;
                for (Map.Entry entry : iIterableNamespaceContext.getPrefixToNamespaceURIMap().entrySet()) {
                    String string = (String)entry.getKey();
                    String string2 = (String)entry.getValue();
                    this.m_aRootNSMap.put((Object)string, (Object)string2);
                }
            } else {
                LOGGER.error("XMLWriter settings has 'putNamespaceContextPrefixesInRoot' set to 'true', but the 'NamespaceContext' instance does not implement the 'IIterableNamespaceContext' interface. This functionality therefore does not work.");
            }
        }
    }

    public final @NonNull IXMLWriterSettings getSettings() {
        return this.m_aSettings;
    }

    protected final void handlePutNamespaceContextPrefixInRoot(@NonNull Map<QName, String> map) {
        if (this.m_aSettings.isEmitNamespaces() && this.m_aNSStack.size() == 1 && this.m_aSettings.isPutNamespaceContextPrefixesInRoot()) {
            for (Map.Entry entry : this.m_aRootNSMap.entrySet()) {
                map.put(XMLHelper.getXMLNSAttrQName((String)entry.getKey()), (String)entry.getValue());
                this.m_aNSStack.addNamespaceMapping((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    protected abstract void emitNode(@NonNull XMLEmitter var1, @Nullable NODETYPE var2, @Nullable NODETYPE var3, @NonNull NODETYPE var4, @Nullable NODETYPE var5);

    @OverrideOnDemand
    protected @NonNull XMLEmitter createXMLEmitter(@WillNotClose @NonNull Writer writer, @NonNull IXMLWriterSettings iXMLWriterSettings) {
        return new XMLEmitter(writer, iXMLWriterSettings);
    }

    public final void write(@NonNull NODETYPE NODETYPE, @NonNull XMLEmitter xMLEmitter) {
        this.emitNode(xMLEmitter, null, null, NODETYPE, null);
    }

    public final void write(@NonNull NODETYPE NODETYPE, @WillNotClose @NonNull OutputStream outputStream) {
        ValueEnforcer.notNull(NODETYPE, (String)"Node");
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        NonBlockingBufferedWriter nonBlockingBufferedWriter = new NonBlockingBufferedWriter((Writer)StreamHelper.createWriter((OutputStream)outputStream, (Charset)this.m_aSettings.getCharset()));
        this.write(NODETYPE, (Writer)nonBlockingBufferedWriter);
    }

    public final void write(@NonNull NODETYPE NODETYPE, @WillNotClose @NonNull Writer writer) {
        XMLEmitter xMLEmitter = this.createXMLEmitter(writer, this.m_aSettings);
        this.emitNode(xMLEmitter, null, null, NODETYPE, null);
        StreamHelper.flush((Flushable)writer);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Settings", (Object)this.m_aSettings).append("Indent", (Object)this.m_aIndent.toString()).append("NamespaceStack", (Object)this.m_aNSStack).getToString();
    }

    protected static final class NamespaceStack {
        private final ICommonsList<NamespaceLevel> m_aStack = new CommonsArrayList();
        private final NamespaceContext m_aNamespaceCtx;

        public NamespaceStack(@NonNull NamespaceContext namespaceContext) {
            this.m_aNamespaceCtx = namespaceContext;
        }

        public void push() {
            NamespaceLevel namespaceLevel = new NamespaceLevel();
            this.m_aStack.add(0, (Object)namespaceLevel);
        }

        public void addNamespaceMapping(@Nullable String string, @NonNull @Nonempty String string2) {
            ((NamespaceLevel)this.m_aStack.getFirstOrNull()).addPrefixNamespaceMapping(string, string2);
        }

        public void pop() {
            this.m_aStack.removeFirstOrNull();
        }

        @Nonnegative
        public int size() {
            return this.m_aStack.size();
        }

        private @Nullable String _getDefaultNamespaceURI() {
            for (NamespaceLevel namespaceLevel : this.m_aStack) {
                String string = namespaceLevel.getDefaultNamespaceURI();
                if (!StringHelper.isNotEmpty((String)string)) continue;
                return string;
            }
            return null;
        }

        private @Nullable String _getUsedPrefixOfNamespace(@NonNull String string) {
            ValueEnforcer.notNull((Object)string, (String)"NamespaceURI");
            for (NamespaceLevel namespaceLevel : this.m_aStack) {
                String string2 = namespaceLevel.getPrefixOfNamespaceURI(string);
                if (string2 == null) continue;
                return string2;
            }
            return null;
        }

        private boolean _containsNoNamespace() {
            return this.m_aStack.containsNone(NamespaceLevel::hasAnyNamespace);
        }

        private boolean _containsNoPrefix(@NonNull String string) {
            return this.m_aStack.containsNone(namespaceLevel -> namespaceLevel.getNamespaceURIOfPrefix(string) != null);
        }

        private @Nullable String _getMappedPrefix(@NonNull String string) {
            String string2;
            ValueEnforcer.notNull((Object)string, (String)"NamespaceURI");
            if (this.m_aNamespaceCtx != null && (string2 = this.m_aNamespaceCtx.getPrefix(string)) != null) {
                return string2;
            }
            return null;
        }

        private @Nullable String _createUniquePrefix() {
            if (this._containsNoNamespace()) {
                return null;
            }
            int n = 0;
            String string;
            while (!this._containsNoPrefix(string = AbstractXMLSerializer.DEFAULT_NAMESPACE_PREFIX_PREFIX + n)) {
                ++n;
            }
            return string;
        }

        public @Nullable String getElementNamespacePrefixToUse(@NonNull String string, boolean bl, @NonNull Map<QName, String> map) {
            String string2 = StringHelper.getNotNull((String)this._getDefaultNamespaceURI());
            if (string.equals(string2)) {
                return null;
            }
            String string3 = this._getUsedPrefixOfNamespace(string);
            if (!(string3 != null || bl && string.length() <= 0)) {
                string3 = this._getMappedPrefix(string);
                if (string3 == null && !bl) {
                    string3 = this._createUniquePrefix();
                }
                map.put(XMLHelper.getXMLNSAttrQName(string3), string);
                this.addNamespaceMapping(string3, string);
            }
            return string3;
        }

        public @Nullable String getAttributeNamespacePrefixToUse(@NonNull String string, @NonNull String string2, @NonNull String string3, @NonNull Map<QName, String> map) {
            String string4 = StringHelper.getNotNull((String)this._getDefaultNamespaceURI());
            if (string.equals(string4)) {
                return null;
            }
            String string5 = this._getUsedPrefixOfNamespace(string);
            if (string5 == null) {
                if ("http://www.w3.org/2000/xmlns/".equals(string)) {
                    string5 = string2;
                    if (!"xmlns".equals(string2)) {
                        map.put(XMLHelper.getXMLNSAttrQName(string5), string3);
                    }
                    this.addNamespaceMapping(string5, string3);
                } else {
                    string5 = this._getMappedPrefix(string);
                    if (string5 == null) {
                        if (string.length() == 0) {
                            return null;
                        }
                        string5 = this._createUniquePrefix();
                    }
                    if (!"xml".equals(string5)) {
                        map.put(XMLHelper.getXMLNSAttrQName(string5), string);
                    }
                    this.addNamespaceMapping(string5, string);
                }
            }
            return string5;
        }
    }

    protected static final class NamespaceLevel {
        private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceLevel.class);
        private String m_sDefaultNamespaceURI;
        private ICommonsMap<String, String> m_aURL2PrefixMap;

        public @Nullable String getNamespaceURIOfPrefix(@Nullable String string) {
            if (StringHelper.isEmpty((String)string)) {
                return this.m_sDefaultNamespaceURI;
            }
            if (this.m_aURL2PrefixMap != null) {
                for (Map.Entry entry : this.m_aURL2PrefixMap.entrySet()) {
                    if (!((String)entry.getValue()).equals(string)) continue;
                    return (String)entry.getKey();
                }
            }
            return null;
        }

        public void addPrefixNamespaceMapping(@Nullable String string, @NonNull String string2) {
            String string3;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Adding namespace mapping " + string + ":" + string2);
            }
            if ((string3 = this.getNamespaceURIOfPrefix(string)) != null && !string3.equals(string2)) {
                LOGGER.warn("Overwriting namespace prefix '" + string + "' to use URL '" + string2 + "' instead of '" + string3 + "'");
            }
            if (StringHelper.isEmpty((String)string)) {
                if (this.m_sDefaultNamespaceURI != null) {
                    LOGGER.warn("Overwriting default namespace '" + this.m_sDefaultNamespaceURI + "' with namespace '" + string2 + "'");
                }
                this.m_sDefaultNamespaceURI = string2;
            } else {
                if (this.m_aURL2PrefixMap == null) {
                    this.m_aURL2PrefixMap = new CommonsHashMap();
                }
                this.m_aURL2PrefixMap.put((Object)string2, (Object)string);
            }
        }

        public @Nullable String getDefaultNamespaceURI() {
            return this.m_sDefaultNamespaceURI;
        }

        public @Nullable String getPrefixOfNamespaceURI(@NonNull String string) {
            if (string.equals(this.m_sDefaultNamespaceURI)) {
                return null;
            }
            return this.m_aURL2PrefixMap == null ? null : (String)this.m_aURL2PrefixMap.get((Object)string);
        }

        @Nonnegative
        public int getNamespaceCount() {
            return (this.m_sDefaultNamespaceURI == null ? 0 : 1) + (this.m_aURL2PrefixMap == null ? 0 : this.m_aURL2PrefixMap.size());
        }

        public boolean hasAnyNamespace() {
            return this.m_sDefaultNamespaceURI != null || this.m_aURL2PrefixMap != null && !this.m_aURL2PrefixMap.isEmpty();
        }

        public String toString() {
            return new ToStringGenerator((Object)this).append("defaultNSURI", (Object)this.m_sDefaultNamespaceURI).append("url2prefix", this.m_aURL2PrefixMap).getToString();
        }
    }
}

