/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.read;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.charset.CharsetHelper;
import com.helger.base.charset.EUnicodeBOM;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class XMLCharsetDeterminator {
    public static final Charset FALLBACK_CHARSET = StandardCharsets.UTF_8;
    private static final ICommonsSet<Charset> XML_CHARSETS = new CommonsHashSet();
    private static final Charset CHARSET_UTF_32BE;
    private static final Charset CHARSET_UTF_32LE;
    private static final Charset CHARSET_EBCDIC;
    private static final Charset CHARSET_IBM290;
    private static final byte[] CS_UTF32_BE;
    private static final byte[] CS_UTF32_LE;
    private static final byte[] CS_UTF16_BE;
    private static final byte[] CS_UTF16_LE;
    private static final byte[] CS_UTF8;
    private static final byte[] CS_EBCDIC;
    private static final byte[] CS_IBM290;

    private XMLCharsetDeterminator() {
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsSet<Charset> getAllSupportedCharsets() {
        return (ICommonsSet)XML_CHARSETS.getClone();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static @Nullable Charset _parseXMLEncoding(byte @NonNull [] byArray, @Nonnegative int n, @NonNull Charset charset) {
        try (NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray, n, byArray.length - n);){
            InputStreamReader inputStreamReader;
            block17: {
                Charset charset2;
                inputStreamReader = new InputStreamReader((InputStream)nonBlockingByteArrayInputStream, charset);
                try {
                    int n2;
                    char c;
                    int n3;
                    StringBuilder stringBuilder = new StringBuilder();
                    int n4 = n + 4096;
                    while ((n3 = ((Reader)inputStreamReader).read()) != -1) {
                        stringBuilder.append((char)n3);
                        if (n3 != 62 || nonBlockingByteArrayInputStream.getPosition() < n4) continue;
                    }
                    int n5 = stringBuilder.length();
                    int n6 = stringBuilder.indexOf("encoding");
                    if (n6 <= 0) break block17;
                    n6 += "encoding".length();
                    while (n6 < n5 && Character.isWhitespace(stringBuilder.charAt(n6))) {
                        ++n6;
                    }
                    if (n6 >= n5 || stringBuilder.charAt(n6) != '=') break block17;
                    ++n6;
                    while (n6 < n5 && Character.isWhitespace(stringBuilder.charAt(n6))) {
                        ++n6;
                    }
                    if (n6 >= n5 || (c = stringBuilder.charAt(n6)) != '\"' && c != '\'' && c != '\u00dc' || (n2 = stringBuilder.indexOf(Character.toString(c), ++n6)) <= 0) break block17;
                    String string = stringBuilder.substring(n6, n2).trim();
                    charset2 = Charset.forName(string);
                }
                catch (Throwable throwable) {
                    try {
                        ((Reader)inputStreamReader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ((Reader)inputStreamReader).close();
                return charset2;
            }
            Charset charset3 = null;
            ((Reader)inputStreamReader).close();
            return charset3;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private static boolean _match(byte @NonNull [] byArray, @Nonnegative int n, byte @NonNull [] byArray2) {
        int n2 = byArray2.length;
        for (int i = 0; i < n2; ++i) {
            if (byArray[n + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static @Nullable Charset determineXMLCharset(byte @NonNull [] byArray) {
        ValueEnforcer.notNull((Object)byArray, (String)"Bytes");
        Charset charset = null;
        int n = 0;
        if (byArray.length > 0) {
            try (NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray, 0, Math.min(EUnicodeBOM.getMaximumByteCount(), byArray.length));){
                CharsetHelper.InputStreamAndCharset inputStreamAndCharset = CharsetHelper.getInputStreamAndCharsetFromBOM((InputStream)nonBlockingByteArrayInputStream);
                if (inputStreamAndCharset.hasBOM()) {
                    n = inputStreamAndCharset.getBOM().getByteCount();
                }
                if (inputStreamAndCharset.hasCharset()) {
                    charset = inputStreamAndCharset.getCharset();
                }
            }
        }
        if (charset == null && byArray.length - n >= 4) {
            if (XMLCharsetDeterminator._match(byArray, n, CS_UTF32_BE)) {
                charset = CHARSET_UTF_32BE;
            } else if (XMLCharsetDeterminator._match(byArray, n, CS_UTF32_LE)) {
                charset = CHARSET_UTF_32LE;
            } else if (XMLCharsetDeterminator._match(byArray, n, CS_UTF16_BE)) {
                charset = StandardCharsets.UTF_16BE;
            } else if (XMLCharsetDeterminator._match(byArray, n, CS_UTF16_LE)) {
                charset = StandardCharsets.UTF_16LE;
            } else if (XMLCharsetDeterminator._match(byArray, n, CS_UTF8)) {
                charset = StandardCharsets.UTF_8;
            } else if (XMLCharsetDeterminator._match(byArray, n, CS_EBCDIC)) {
                charset = CHARSET_EBCDIC;
            } else if (XMLCharsetDeterminator._match(byArray, n, CS_IBM290)) {
                charset = CHARSET_IBM290;
            }
        }
        if (charset == null) {
            charset = FALLBACK_CHARSET;
        }
        return XMLCharsetDeterminator._parseXMLEncoding(byArray, n, charset);
    }

    static {
        for (Charset charset : CharsetHelper.getAllCharsets().values()) {
            if (!charset.canEncode() || charset.name().equals("JIS_X0212-1990") || charset.name().equals("x-IBM300") || charset.name().equals("x-IBM834") || charset.name().equals("x-JIS0208") || charset.name().equals("x-MacDingbat") || charset.name().equals("x-MacSymbol")) continue;
            XML_CHARSETS.add((Object)charset);
        }
        CHARSET_UTF_32BE = Charset.forName("UTF-32BE");
        CHARSET_UTF_32LE = Charset.forName("UTF-32LE");
        CHARSET_EBCDIC = Charset.forName("Cp1047");
        CHARSET_IBM290 = Charset.forName("IBM290");
        CS_UTF32_BE = new byte[]{0, 0, 0, 60};
        CS_UTF32_LE = new byte[]{60, 0, 0, 0};
        CS_UTF16_BE = new byte[]{0, 60, 0, 63};
        CS_UTF16_LE = new byte[]{60, 0, 63, 0};
        CS_UTF8 = new byte[]{60, 63, 120, 109};
        CS_EBCDIC = new byte[]{76, 111, -89, -108};
        CS_IBM290 = new byte[]{76, 111, -73, 117};
    }
}

