/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.serialize;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.base.location.SimpleLocation;
import com.helger.base.string.StringHelper;
import com.helger.diagnostics.error.level.EErrorLevel;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.xml.microdom.IMicroCDATA;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroDocumentType;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroText;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.MicroDocumentType;
import com.helger.xml.sax.AbstractSAXErrorHandler;
import java.io.IOException;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;

public class MicroSAXHandler
implements EntityResolver2,
DTDHandler,
ContentHandler,
ErrorHandler,
LexicalHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroSAXHandler.class);
    private IMicroDocument m_aDoc;
    private IMicroDocumentType m_aDocType;
    private IMicroNode m_aParent;
    private boolean m_bDTDMode = false;
    private boolean m_bCDATAMode = false;
    private final boolean m_bSaveIgnorableWhitespaces;
    private final EntityResolver m_aEntityResolver;
    private final EntityResolver2 m_aEntityResolver2;
    private final boolean m_bTrackPosition;
    private Locator m_aLocator;
    private String m_sSourceXMLVersion;
    private String m_sSourceXMLEncoding;

    public MicroSAXHandler(boolean bl, @Nullable EntityResolver entityResolver, boolean bl2) {
        EntityResolver2 entityResolver2;
        this.m_bSaveIgnorableWhitespaces = bl;
        this.m_aEntityResolver = entityResolver;
        this.m_aEntityResolver2 = entityResolver instanceof EntityResolver2 ? (entityResolver2 = (EntityResolver2)entityResolver) : null;
        this.m_bTrackPosition = bl2;
    }

    private void _createParentDocument() {
        if (this.m_aParent == null) {
            this.m_aDoc = new MicroDocument(this.m_aDocType);
            this.m_aParent = this.m_aDoc;
        }
    }

    private void _updatePosition(@NonNull String string) {
        if (this.m_aLocator != null) {
            SimpleLocation simpleLocation = SimpleLocation.create((Locator)this.m_aLocator);
        }
    }

    @Override
    public void setDocumentLocator(@Nullable Locator locator) {
        if (this.m_bTrackPosition) {
            this.m_aLocator = locator;
            this._updatePosition("setLocator");
            if (locator instanceof Locator2) {
                Locator2 locator2 = (Locator2)locator;
                this.m_sSourceXMLVersion = locator2.getXMLVersion();
                this.m_sSourceXMLEncoding = locator2.getEncoding();
            }
        }
    }

    @Override
    public void startDocument() {
        this._updatePosition("startDocument");
    }

    @Override
    public void endDocument() {
        this._updatePosition("endDocument");
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        this._updatePosition("startDTD");
        if (this.m_aDocType == null) {
            this.m_aDocType = new MicroDocumentType(string, string2, string3);
        } else {
            LOGGER.warn("DocType already present!");
        }
        this.m_bDTDMode = true;
    }

    @Override
    public void endDTD() throws SAXException {
        this._updatePosition("endDTD");
        this.m_bDTDMode = false;
    }

    @Override
    public void startElement(@Nullable String string, @NonNull String string2, @Nullable String string3, @Nullable Attributes attributes) {
        this._updatePosition("startElement");
        this._createParentDocument();
        IMicroElement iMicroElement = StringHelper.isNotEmpty((String)string) ? this.m_aParent.addElementNS(string, string2) : this.m_aParent.addElement(string2);
        if (attributes != null) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string4 = attributes.getURI(i);
                String string5 = attributes.getLocalName(i);
                String string6 = attributes.getValue(i);
                if (string5.startsWith("xmlns")) continue;
                iMicroElement.setAttributeNS(string4, string5, string6);
            }
        }
        this.m_aParent = iMicroElement;
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this._updatePosition("endElement");
        this.m_aParent = this.m_aParent.getParent();
    }

    @Override
    public void processingInstruction(String string, String string2) {
        this._updatePosition("processingInstruction");
        this._createParentDocument();
        this.m_aParent.addProcessingInstruction(string, string2);
    }

    @Override
    public void characters(char @NonNull [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this._updatePosition("characters");
        if (this.m_bCDATAMode) {
            IMicroNode iMicroNode = this.m_aParent.getLastChild();
            if (iMicroNode != null && iMicroNode.getType().isCDATA()) {
                IMicroCDATA iMicroCDATA = (IMicroCDATA)iMicroNode;
                iMicroCDATA.appendData(cArray, n, n2);
            } else {
                this.m_aParent.addCDATA(cArray, n, n2);
            }
        } else {
            IMicroNode iMicroNode = this.m_aParent.getLastChild();
            if (iMicroNode != null && iMicroNode.getType().isText()) {
                IMicroText iMicroText = (IMicroText)iMicroNode;
                if (!iMicroText.isElementContentWhitespace()) {
                    iMicroText.appendData(cArray, n, n2);
                } else {
                    this.m_aParent.addText(cArray, n, n2);
                }
            } else {
                this.m_aParent.addText(cArray, n, n2);
            }
        }
    }

    @Override
    public void comment(char @NonNull [] cArray, @Nonnegative int n, @Nonnegative int n2) throws SAXException {
        this._updatePosition("comment");
        if (!this.m_bDTDMode) {
            this._createParentDocument();
            this.m_aParent.addComment(cArray, n, n2);
        }
    }

    @Override
    public void ignorableWhitespace(char @NonNull [] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this._updatePosition("ignorableWhitespace");
        if (this.m_bSaveIgnorableWhitespaces) {
            IMicroNode iMicroNode = this.m_aParent.getLastChild();
            if (iMicroNode != null && iMicroNode.getType().isText()) {
                IMicroText iMicroText = (IMicroText)iMicroNode;
                if (iMicroText.isElementContentWhitespace()) {
                    iMicroText.appendData(cArray, n, n2);
                } else {
                    this.m_aParent.addIgnorableWhitespaceText(cArray, n, n2);
                }
            } else {
                this.m_aParent.addIgnorableWhitespaceText(cArray, n, n2);
            }
        }
    }

    @Override
    public @Nullable InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        this._updatePosition("resolveEntity");
        EntityResolver entityResolver = this.m_aEntityResolver;
        if (entityResolver != null) {
            return entityResolver.resolveEntity(string, string2);
        }
        if (string == null) {
            LOGGER.info("Need to resolve entity with system ID '" + string2 + "'");
        } else if (string2 == null) {
            LOGGER.info("Need to resolve entity with public ID '" + string + "'");
        } else {
            LOGGER.info("Need to resolve entity with public ID '" + string + "' and system ID '" + string2 + "'");
        }
        return null;
    }

    @Override
    public @Nullable InputSource getExternalSubset(String string, @Nullable String string2) throws SAXException, IOException {
        this._updatePosition("getExternalSubset");
        EntityResolver2 entityResolver2 = this.m_aEntityResolver2;
        if (entityResolver2 != null) {
            return entityResolver2.getExternalSubset(string, string2);
        }
        return null;
    }

    @Override
    public @Nullable InputSource resolveEntity(@Nullable String string, @Nullable String string2, @Nullable String string3, @NonNull String string4) throws SAXException, IOException {
        this._updatePosition("resolveEntity2");
        EntityResolver2 entityResolver2 = this.m_aEntityResolver2;
        if (entityResolver2 != null) {
            return entityResolver2.resolveEntity(string, string2, string3, string4);
        }
        EntityResolver entityResolver = this.m_aEntityResolver;
        if (entityResolver != null) {
            return entityResolver.resolveEntity(string2, string4);
        }
        LOGGER.info("Need to resolve entity with name '" + string + "', public ID '" + string2 + "' base URI '" + string3 + "' and system ID '" + string4 + "'");
        return null;
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        this._updatePosition("unparsedEntityDecl");
        LOGGER.warn("Unparsed entity decl: " + string + "--" + string2 + "--" + string3 + "--" + string4);
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        this._updatePosition("notationDecl");
        LOGGER.warn("Unparsed notation decl: " + string + "--" + string2 + "--" + string3);
    }

    @Override
    public void skippedEntity(String string) {
        this._updatePosition("skippedEntity");
        LOGGER.warn("Skipped entity: " + string);
    }

    @Override
    public void startEntity(String string) throws SAXException {
        this._updatePosition("startEntity");
    }

    @Override
    public void endEntity(String string) throws SAXException {
        this._updatePosition("endEntity");
    }

    @Override
    public void startCDATA() throws SAXException {
        this._updatePosition("startCDATA");
        this.m_bCDATAMode = true;
    }

    @Override
    public void endCDATA() throws SAXException {
        this._updatePosition("endCDATA");
        this.m_bCDATAMode = false;
    }

    @Override
    public void startPrefixMapping(@NonNull String string, @NonNull String string2) throws SAXException {
    }

    @Override
    public void endPrefixMapping(@NonNull String string) throws SAXException {
    }

    private static @NonNull @Nonempty String _getMsg(@NonNull IErrorLevel iErrorLevel, @NonNull SAXParseException sAXParseException) {
        return AbstractSAXErrorHandler.getSaxParseError(iErrorLevel, sAXParseException).getAsString(Locale.ROOT);
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        LOGGER.warn(MicroSAXHandler._getMsg((IErrorLevel)EErrorLevel.WARN, sAXParseException));
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        LOGGER.error(MicroSAXHandler._getMsg((IErrorLevel)EErrorLevel.ERROR, sAXParseException));
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) {
        LOGGER.error(MicroSAXHandler._getMsg((IErrorLevel)EErrorLevel.FATAL_ERROR, sAXParseException));
    }

    public @Nullable IMicroDocument getDocument() {
        return this.m_aDoc;
    }

    public @Nullable String getSourceXMLVersion() {
        return this.m_sSourceXMLVersion;
    }

    public @Nullable String getSourceXMLEncoding() {
        return this.m_sSourceXMLEncoding;
    }
}

