/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.xml.microdom.AbstractMicroNode;
import com.helger.xml.microdom.EMicroNodeType;
import com.helger.xml.microdom.IMicroDocumentType;
import com.helger.xml.microdom.IMicroNode;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class MicroDocumentType
extends AbstractMicroNode
implements IMicroDocumentType {
    public static final String NODE_NAME = "#doctype";
    private final String m_sQualifiedName;
    private final String m_sPublicID;
    private final String m_sSystemID;

    public MicroDocumentType(@NonNull IMicroDocumentType iMicroDocumentType) {
        this(iMicroDocumentType.getQualifiedName(), iMicroDocumentType.getPublicID(), iMicroDocumentType.getSystemID());
    }

    public MicroDocumentType(@NonNull String string, @Nullable String string2, @Nullable String string3) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"QualifiedName");
        this.m_sQualifiedName = string;
        this.m_sPublicID = string2;
        this.m_sSystemID = string3;
    }

    @Override
    public @NonNull EMicroNodeType getType() {
        return EMicroNodeType.DOCUMENT_TYPE;
    }

    @Override
    public @NonNull String getNodeName() {
        return NODE_NAME;
    }

    @Override
    public @NonNull String getQualifiedName() {
        return this.m_sQualifiedName;
    }

    @Override
    public @Nullable String getPublicID() {
        return this.m_sPublicID;
    }

    @Override
    public @Nullable String getSystemID() {
        return this.m_sSystemID;
    }

    @Override
    public @NonNull IMicroDocumentType getClone() {
        return new MicroDocumentType(this);
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (iMicroNode == null || !this.getClass().equals(iMicroNode.getClass())) {
            return false;
        }
        MicroDocumentType microDocumentType = (MicroDocumentType)iMicroNode;
        return this.m_sQualifiedName.equals(microDocumentType.m_sQualifiedName) && EqualsHelper.equals((Object)this.m_sPublicID, (Object)microDocumentType.m_sPublicID) && EqualsHelper.equals((Object)this.m_sSystemID, (Object)microDocumentType.m_sSystemID);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("qualifiedName", (Object)this.m_sQualifiedName).append("publicID", (Object)this.m_sPublicID).append("systemID", (Object)this.m_sSystemID).getToString();
    }
}

