/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.builder.IBuilder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.string.StringHelper;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsIterableIterator;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.xml.CXML;
import com.helger.xml.ChildElementIterator;
import com.helger.xml.NamedNodeMapIterator;
import com.helger.xml.NodeListIterator;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Immutable
public final class XMLHelper {
    private static final XMLHelper INSTANCE = new XMLHelper();

    private XMLHelper() {
    }

    public static @Nullable Document getOwnerDocument(@Nullable Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Document) {
            Document document = (Document)node;
            return document;
        }
        return node.getOwnerDocument();
    }

    public static @Nullable Element getDocumentElement(@Nullable Node node) {
        Document document = XMLHelper.getOwnerDocument(node);
        return document == null ? null : document.getDocumentElement();
    }

    public static @Nullable String getNamespaceURI(@Nullable Node node) {
        if (node instanceof Document) {
            Document document = (Document)node;
            return XMLHelper.getNamespaceURI(document.getDocumentElement());
        }
        if (node != null) {
            return node.getNamespaceURI();
        }
        return null;
    }

    public static @NonNull String getLocalNameOrTagName(@NonNull Element element) {
        String string = element.getLocalName();
        if (string == null) {
            string = element.getTagName();
        }
        return string;
    }

    public static @NonNull String getLocalNameOrName(@NonNull Attr attr) {
        String string = attr.getLocalName();
        if (string == null) {
            string = attr.getName();
        }
        return string;
    }

    public static @Nullable String getElementName(@Nullable Node node) {
        if (node instanceof Document) {
            Document document = (Document)node;
            return XMLHelper.getElementName(document.getDocumentElement());
        }
        if (node instanceof Element) {
            Element element = (Element)node;
            return XMLHelper.getLocalNameOrTagName(element);
        }
        return null;
    }

    public static boolean hasNoNamespaceURI(@NonNull Node node) {
        return StringHelper.isEmpty((String)node.getNamespaceURI());
    }

    public static boolean hasNamespaceURI(@Nullable Node node, @Nullable String string) {
        String string2 = node == null ? null : node.getNamespaceURI();
        return string2 != null && string2.equals(string);
    }

    public static boolean isInlineNode(@Nullable Node node) {
        return node instanceof Text || node instanceof EntityReference;
    }

    @Nonnegative
    public static int getLength(@Nullable NodeList nodeList) {
        return nodeList == null ? 0 : nodeList.getLength();
    }

    public static boolean isEmpty(@Nullable NodeList nodeList) {
        return nodeList == null || nodeList.getLength() == 0;
    }

    public static @NonNull Predicate<? super Node> filterNodeIsElement() {
        return node -> node != null && node.getNodeType() == 1;
    }

    public static @NonNull Predicate<? super Element> filterElementWithNamespace() {
        return element -> element != null && StringHelper.isNotEmpty((String)element.getNamespaceURI());
    }

    public static @NonNull Predicate<? super Element> filterElementWithoutNamespace() {
        return element -> element != null && XMLHelper.hasNoNamespaceURI(element);
    }

    public static @NonNull Predicate<? super Element> filterElementWithNamespace(@Nullable String string) {
        return element -> element != null && XMLHelper.hasNamespaceURI(element, string);
    }

    public static @NonNull Predicate<? super Element> filterElementWithNamespaceAndLocalName(@Nullable String string, @NonNull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"LocalName");
        return element -> element != null && XMLHelper.hasNamespaceURI(element, string) && element.getLocalName().equals(string2);
    }

    public static @NonNull Predicate<? super Element> filterElementWithTagName(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"TagName");
        return element -> EqualsHelper.equals((Object)XMLHelper.getElementName(element), (Object)string);
    }

    public static @NonNull Predicate<? super Element> filterElementWithTagNameNoNS(@NonNull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"TagName");
        return element -> XMLHelper.hasNoNamespaceURI(element) && element.getTagName().equals(string);
    }

    public static @Nullable Element getFirstChildElement(@Nullable Node node) {
        if (node == null) {
            return null;
        }
        return (Element)NodeListIterator.createChildNodeIterator(node).findFirstMapped(XMLHelper.filterNodeIsElement(), Element.class::cast);
    }

    public static boolean hasChildElementNodes(@Nullable Node node) {
        if (node == null) {
            return false;
        }
        return NodeListIterator.createChildNodeIterator(node).containsAny(XMLHelper.filterNodeIsElement());
    }

    public static @Nullable Element getFirstChildElementOfName(@Nullable Node node, @NonNull @Nonempty String string) {
        if (node == null) {
            return null;
        }
        return (Element)new ChildElementIterator(node).findFirst(XMLHelper.filterElementWithTagName(string));
    }

    public static @Nullable Element getFirstChildElementOfName(@Nullable Node node, @Nullable String string, @NonNull @Nonempty String string2) {
        if (node == null) {
            return null;
        }
        return (Element)new ChildElementIterator(node).findFirst(XMLHelper.filterElementWithNamespaceAndLocalName(string, string2));
    }

    public static @Nullable Element getChildElementOfNames(@Nullable Element element, String ... stringArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])stringArray, (String)"TagNames");
        Element element2 = element;
        if (element2 != null) {
            for (String string : stringArray) {
                if ((element2 = XMLHelper.getFirstChildElementOfName(element2, string)) != null) continue;
                return null;
            }
        }
        return element2;
    }

    public static @NonNull Node append(@NonNull Node node, @Nullable Object object) {
        ValueEnforcer.notNull((Object)node, (String)"ParentNode");
        if (object != null) {
            if (object instanceof Document) {
                Document document = (Document)object;
                XMLHelper.append(node, document.getDocumentElement());
            } else if (object instanceof Node) {
                Node node2 = (Node)object;
                Document document = XMLHelper.getOwnerDocument(node);
                if (XMLHelper.getOwnerDocument(node2).equals(document)) {
                    node.appendChild(node2);
                } else {
                    node.appendChild(document.adoptNode(node2.cloneNode(true)));
                }
            } else if (object instanceof String) {
                String string = (String)object;
                node.appendChild(XMLHelper.getOwnerDocument(node).createTextNode(string));
            } else if (object instanceof Iterable) {
                Iterable iterable = (Iterable)object;
                for (Object t : iterable) {
                    XMLHelper.append(node, t);
                }
            } else if (ArrayHelper.isArray((Object)object)) {
                for (Object object2 : (Object[])object) {
                    XMLHelper.append(node, object2);
                }
            } else {
                throw new IllegalArgumentException("Passed object cannot be appended to a DOMNode (type=" + object.getClass().getName() + ".");
            }
        }
        return node;
    }

    public static void append(@NonNull Node node, @NonNull Iterable<?> iterable) {
        ValueEnforcer.notNull((Object)node, (String)"ParentNode");
        for (Object obj : iterable) {
            XMLHelper.append(node, obj);
        }
    }

    @Nonnegative
    public static int getDirectChildElementCount(@Nullable Element element) {
        return element == null ? 0 : CollectionHelper.getSize(XMLHelper.getChildElementIterator(element));
    }

    @Nonnegative
    public static int getDirectChildElementCountNoNS(@Nullable Element element) {
        return element == null ? 0 : CollectionHelper.getSize(XMLHelper.getChildElementIteratorNoNS(element));
    }

    @Nonnegative
    public static int getDirectChildElementCount(@Nullable Element element, @NonNull @Nonempty String string) {
        return element == null ? 0 : CollectionHelper.getSize(XMLHelper.getChildElementIterator(element, string));
    }

    @Nonnegative
    public static int getDirectChildElementCountNoNS(@Nullable Element element, @NonNull @Nonempty String string) {
        return element == null ? 0 : CollectionHelper.getSize(XMLHelper.getChildElementIteratorNoNS(element, string));
    }

    @Nonnegative
    public static int getDirectChildElementCountNS(@Nullable Element element, @Nullable String string) {
        return element == null ? 0 : CollectionHelper.getSize(XMLHelper.getChildElementIteratorNS(element, string));
    }

    @Nonnegative
    public static int getDirectChildElementCountNS(@Nullable Element element, @Nullable String string, @NonNull @Nonempty String string2) {
        return element == null ? 0 : CollectionHelper.getSize(XMLHelper.getChildElementIteratorNS(element, string, string2));
    }

    public static @NonNull ICommonsIterableIterator<Element> getChildElementIterator(@Nullable Node node) {
        return new ChildElementIterator(node);
    }

    public static @NonNull ICommonsIterableIterator<Element> getChildElementIteratorNoNS(@Nullable Node node) {
        return new ChildElementIterator(node).withFilter(XMLHelper.filterElementWithoutNamespace());
    }

    public static @NonNull ICommonsIterableIterator<Element> getChildElementIteratorNoNS(@Nullable Node node, @NonNull @Nonempty String string) {
        return new ChildElementIterator(node).withFilter(XMLHelper.filterElementWithTagNameNoNS(string));
    }

    public static @NonNull ICommonsIterableIterator<Element> getChildElementIterator(@Nullable Node node, @NonNull @Nonempty String string) {
        return new ChildElementIterator(node).withFilter(XMLHelper.filterElementWithTagName(string));
    }

    public static @NonNull ICommonsIterableIterator<Element> getChildElementIteratorNS(@Nullable Node node, @Nullable String string) {
        return new ChildElementIterator(node).withFilter(XMLHelper.filterElementWithNamespace(string));
    }

    public static @NonNull ICommonsIterableIterator<Element> getChildElementIteratorNS(@Nullable Node node, @Nullable String string, @NonNull @Nonempty String string2) {
        return new ChildElementIterator(node).withFilter(XMLHelper.filterElementWithNamespaceAndLocalName(string, string2));
    }

    public static boolean hasSameElementName(@NonNull Element element, @NonNull Element element2) {
        String string = element.getNamespaceURI();
        String string2 = element2.getNamespaceURI();
        if (StringHelper.isNotEmpty((String)string)) {
            return string.equals(string2) && element.getLocalName().equals(element2.getLocalName());
        }
        return StringHelper.isEmpty((String)string2) && element.getTagName().equals(element2.getTagName());
    }

    private static @NonNull String _getPathToNode(@NonNull Node node, @NonNull String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, @Nullable NamespaceContext namespaceContext) {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        ValueEnforcer.notNull((Object)string2, (String)"Separator");
        Function<String, String> function = namespaceContext == null ? string -> "" : string -> {
            String string2;
            String string3 = string;
            if (StringHelper.isNotEmpty((String)string3) && StringHelper.isNotEmpty((String)(string2 = namespaceContext.getPrefix((String)string)))) {
                return string2 + ":";
            }
            return "";
        };
        StringBuilder stringBuilder = new StringBuilder(128);
        Node node2 = node;
        while (node2 != null) {
            short s = node2.getNodeType();
            if (bl && s == 9 && stringBuilder.length() > 0) {
                stringBuilder.insert(0, string2);
                break;
            }
            String string3 = node2.getNamespaceURI();
            StringBuilder stringBuilder2 = new StringBuilder();
            if (s == 2) {
                stringBuilder2.append('@');
            }
            if (StringHelper.isNotEmpty((String)string3)) {
                stringBuilder2.append(function.apply(string3));
                stringBuilder2.append(node2.getLocalName());
            } else {
                stringBuilder2.append(node2.getNodeName());
            }
            Node node3 = s == 2 ? ((Attr)node2).getOwnerElement() : node2.getParentNode();
            if (node3 != null && s == 1) {
                if (node3.getNodeType() == 1) {
                    Element element = (Element)node2;
                    int n = 0;
                    int n2 = -1;
                    Iterator iterator = new ChildElementIterator(node3).iterator();
                    while (iterator.hasNext()) {
                        boolean bl6;
                        Element element2 = (Element)iterator.next();
                        if (EqualsHelper.identityEqual((Object)element2, (Object)node2)) {
                            n2 = n;
                        }
                        if (!(bl6 = bl5 ? XMLHelper.hasSameElementName(element2, element) : element2.getTagName().equals(element.getTagName()))) continue;
                        ++n;
                    }
                    if (n2 < 0) {
                        throw new IllegalStateException("Failed to find Node with name '" + element.getTagName() + "' at parent");
                    }
                    if (n > 1 || bl3) {
                        stringBuilder2.append('[').append(bl2 ? n2 : n2 + 1).append(']');
                    }
                } else if (bl3) {
                    stringBuilder2.append('[').append(bl2 ? 0 : 1).append(']');
                }
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, string2);
            }
            stringBuilder.insert(0, stringBuilder2);
            node2 = node3;
        }
        if (bl4 && stringBuilder.length() > 0) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static @NonNull PathToNodeBuilder pathToNodeBuilder() {
        return new PathToNodeBuilder();
    }

    public static @NonNull String getPathToNode(@NonNull Node node) {
        return XMLHelper.getPathToNode(node, "/");
    }

    public static @NonNull String getPathToNode(@NonNull Node node, @NonNull String string) {
        return XMLHelper.pathToNodeBuilder().node(node).separator(string).includeDocumentNode().zeroBasedIndex().forceUseIndex(true).trailingSeparator(true).compareIncludingNamespaceURI(false).build();
    }

    public static @NonNull String getPathToNode2(@NonNull Node node) {
        return XMLHelper.getPathToNode2(node, "/");
    }

    public static @NonNull String getPathToNode2(@NonNull Node node, @NonNull String string) {
        return XMLHelper.pathToNodeBuilder().node(node).separator(string).excludeDocumentNode().zeroBasedIndex().forceUseIndex(false).trailingSeparator(false).compareIncludingNamespaceURI(false).build();
    }

    public static void removeAllChildElements(@NonNull Element element) {
        ValueEnforcer.notNull((Object)element, (String)"Element");
        while (element.getChildNodes().getLength() > 0) {
            element.removeChild(element.getChildNodes().item(0));
        }
    }

    public static @Nullable String getFirstChildText(@Nullable Node node2) {
        return (String)NodeListIterator.createChildNodeIterator(node2).findFirstMapped(node -> node instanceof Text && !((Text)node).isElementContentWhitespace(), node -> ((Text)node).getData());
    }

    public static @Nullable String getAttributeValue(@NonNull Element element, @NonNull String string) {
        return XMLHelper.getAttributeValue(element, string, null);
    }

    public static @Nullable String getAttributeValue(@NonNull Element element, @NonNull String string, @Nullable String string2) {
        Attr attr = element.getAttributeNode(string);
        return attr == null ? string2 : attr.getValue();
    }

    public static @Nullable String getAttributeValueNS(@NonNull Element element, @Nullable String string, @NonNull String string2) {
        return XMLHelper.getAttributeValueNS(element, string, string2, null);
    }

    public static @Nullable String getAttributeValueNS(@NonNull Element element, @Nullable String string, @NonNull String string2, @Nullable String string3) {
        Attr attr = element.getAttributeNodeNS(string, string2);
        return attr == null ? string3 : attr.getValue();
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsList<Attr> getAllAttributesAsList(@Nullable Element element) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        NamedNodeMapIterator.createAttributeIterator(element).forEach(arg_0 -> XMLHelper.lambda$getAllAttributesAsList$11((ICommonsList)commonsArrayList, arg_0));
        return commonsArrayList;
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsOrderedMap<String, String> getAllAttributesAsMap(@Nullable Element element) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        XMLHelper.forAllAttributes(element, (arg_0, arg_1) -> ((ICommonsOrderedMap)commonsLinkedHashMap).put(arg_0, arg_1));
        return commonsLinkedHashMap;
    }

    public static void forAllAttributes(@Nullable Element element, @NonNull Consumer<? super Attr> consumer) {
        NamedNodeMapIterator.createAttributeIterator(element).forEach(node -> consumer.accept((Attr)node));
    }

    public static void forAllAttributes(@Nullable Element element, @NonNull BiConsumer<? super String, ? super String> biConsumer) {
        XMLHelper.forAllAttributes(element, (? super Attr attr) -> biConsumer.accept(attr.getName(), attr.getValue()));
    }

    public static @NonNull QName getXMLNSAttrQName(@Nullable String string) {
        if (string != null) {
            ValueEnforcer.isFalse((boolean)string.contains(CXML.XML_PREFIX_NAMESPACE_SEP_STR), () -> "prefix is invalid: " + string);
        }
        if (string == null || string.equals("")) {
            return new QName("http://www.w3.org/2000/xmlns/", "xmlns");
        }
        return new QName("http://www.w3.org/2000/xmlns/", string, "xmlns");
    }

    public static @NonNull String getPrefix(@Nullable Element element) {
        String string = element == null ? null : element.getPrefix();
        return string == null ? "" : string;
    }

    public static @NonNull QName getQName(@NonNull Element element) {
        String string = element.getNamespaceURI();
        if (string == null) {
            return new QName(element.getTagName());
        }
        return new QName(string, element.getLocalName(), XMLHelper.getPrefix(element));
    }

    public static void iterateChildren(@NonNull Node node, @NonNull Consumer<? super Node> consumer) {
        ValueEnforcer.notNull((Object)node, (String)"Parent");
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                consumer.accept(node2);
            }
        }
    }

    private static void _recursiveIterateChildren(@NonNull Node node, @NonNull Consumer<? super Node> consumer) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                consumer.accept(node2);
                XMLHelper._recursiveIterateChildren(node2, consumer);
            }
        }
    }

    public static void recursiveIterateChildren(@NonNull Node node, @NonNull Consumer<? super Node> consumer) {
        ValueEnforcer.notNull((Object)node, (String)"Parent");
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        XMLHelper._recursiveIterateChildren(node, consumer);
    }

    private static /* synthetic */ void lambda$getAllAttributesAsList$11(ICommonsList iCommonsList, Node node) {
        iCommonsList.add((Object)((Attr)node));
    }

    @NotThreadSafe
    public static class PathToNodeBuilder
    implements IBuilder<String> {
        private Node m_aNode;
        private String m_sSeperator;
        private boolean m_bExcludeDocumentNode;
        private boolean m_bZeroBasedIndex;
        private boolean m_bForceUseIndex;
        private boolean m_bTrailingSeparator;
        private boolean m_bCompareIncludingNamespaceURI;
        private NamespaceContext m_aNamespaceCtx;

        public PathToNodeBuilder() {
            this.separator("/");
            this.excludeDocumentNode(true);
            this.zeroBasedIndex(false);
            this.forceUseIndex(false);
            this.trailingSeparator(false);
            this.compareIncludingNamespaceURI(true);
        }

        public @NonNull PathToNodeBuilder node(@Nullable Node node) {
            this.m_aNode = node;
            return this;
        }

        public @NonNull PathToNodeBuilder separator(char c) {
            return this.separator(Character.toString(c));
        }

        public @NonNull PathToNodeBuilder separator(@Nullable String string) {
            this.m_sSeperator = string;
            return this;
        }

        public @NonNull PathToNodeBuilder excludeDocumentNode(boolean bl) {
            this.m_bExcludeDocumentNode = bl;
            return this;
        }

        public @NonNull PathToNodeBuilder excludeDocumentNode() {
            return this.excludeDocumentNode(true);
        }

        public @NonNull PathToNodeBuilder includeDocumentNode() {
            return this.excludeDocumentNode(false);
        }

        public @NonNull PathToNodeBuilder zeroBasedIndex(boolean bl) {
            this.m_bZeroBasedIndex = bl;
            return this;
        }

        public @NonNull PathToNodeBuilder zeroBasedIndex() {
            return this.zeroBasedIndex(true);
        }

        public @NonNull PathToNodeBuilder oneBasedIndex() {
            return this.zeroBasedIndex(false);
        }

        public @NonNull PathToNodeBuilder forceUseIndex(boolean bl) {
            this.m_bForceUseIndex = bl;
            return this;
        }

        public @NonNull PathToNodeBuilder trailingSeparator(boolean bl) {
            this.m_bTrailingSeparator = bl;
            return this;
        }

        public @NonNull PathToNodeBuilder compareIncludingNamespaceURI(boolean bl) {
            this.m_bCompareIncludingNamespaceURI = bl;
            return this;
        }

        public @NonNull PathToNodeBuilder namespaceContext(@Nullable NamespaceContext namespaceContext) {
            this.m_aNamespaceCtx = namespaceContext;
            return this;
        }

        public @NonNull String build() {
            if (this.m_aNode == null) {
                throw new IllegalStateException("A source Node need to be provided");
            }
            if (this.m_sSeperator == null) {
                throw new IllegalStateException("A non-null separator needs to be provided");
            }
            return XMLHelper._getPathToNode(this.m_aNode, this.m_sSeperator, this.m_bExcludeDocumentNode, this.m_bZeroBasedIndex, this.m_bForceUseIndex, this.m_bTrailingSeparator, this.m_bCompareIncludingNamespaceURI, this.m_aNamespaceCtx);
        }
    }
}

