/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.schema;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.classloader.IHasClassLoader;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.state.EChange;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.xml.ls.SimpleLSResourceResolver;
import com.helger.xml.sax.LoggingSAXErrorHandler;
import com.helger.xml.schema.SchemaCache;
import javax.xml.validation.SchemaFactory;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;

@ThreadSafe
public class XMLSchemaCache
extends SchemaCache {
    public static final String SCHEMA_TYPE_NAME = "XSD";
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsMap<String, XMLSchemaCache> PER_CL_CACHE = new CommonsHashMap();
    private static boolean s_bDefaultInstantiated = false;

    public static @NonNull SchemaFactory createXSDSchemaFactory() {
        return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    }

    public XMLSchemaCache() {
        this(new LoggingSAXErrorHandler(), new SimpleLSResourceResolver());
    }

    public XMLSchemaCache(@Nullable ErrorHandler errorHandler) {
        this(errorHandler, null);
    }

    public XMLSchemaCache(@Nullable LSResourceResolver lSResourceResolver) {
        this(null, lSResourceResolver);
    }

    public XMLSchemaCache(@Nullable ErrorHandler errorHandler, @Nullable LSResourceResolver lSResourceResolver) {
        this(XMLSchemaCache.createXSDSchemaFactory(), errorHandler, lSResourceResolver);
    }

    public XMLSchemaCache(@NonNull SchemaFactory schemaFactory, @Nullable ErrorHandler errorHandler, @Nullable LSResourceResolver lSResourceResolver) {
        super(SCHEMA_TYPE_NAME, schemaFactory, errorHandler, lSResourceResolver);
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    public static @NonNull XMLSchemaCache getInstance() {
        XMLSchemaCache xMLSchemaCache = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return xMLSchemaCache;
    }

    public static @NonNull XMLSchemaCache getInstanceOfClassLoader(@Nullable IHasClassLoader iHasClassLoader) {
        return XMLSchemaCache.getInstanceOfClassLoader(iHasClassLoader == null ? null : iHasClassLoader.getClassLoader());
    }

    public static @NonNull XMLSchemaCache getInstanceOfClassLoader(@Nullable ClassLoader classLoader) {
        if (classLoader == null) {
            return XMLSchemaCache.getInstance();
        }
        String string = String.valueOf(classLoader);
        XMLSchemaCache xMLSchemaCache = (XMLSchemaCache)((Object)RW_LOCK.readLockedGet(() -> (XMLSchemaCache)((Object)((Object)PER_CL_CACHE.get((Object)string)))));
        if (xMLSchemaCache == null) {
            xMLSchemaCache = (XMLSchemaCache)((Object)RW_LOCK.writeLockedGet(() -> (XMLSchemaCache)((Object)((Object)PER_CL_CACHE.computeIfAbsent((Object)string, string -> new XMLSchemaCache(new SimpleLSResourceResolver(classLoader)))))));
        }
        return xMLSchemaCache;
    }

    public static @NonNull EChange clearPerClassLoaderCache() {
        return (EChange)RW_LOCK.writeLockedGet(() -> PER_CL_CACHE.removeAll());
    }

    private static final class SingletonHolder {
        private static final XMLSchemaCache INSTANCE = new XMLSchemaCache();

        private SingletonHolder() {
        }
    }
}

