/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.schema;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.diagnostics.error.list.ErrorList;
import com.helger.diagnostics.error.list.IErrorList;
import com.helger.io.resource.IReadableResource;
import com.helger.xml.EXMLParserProperty;
import com.helger.xml.sax.WrappedCollectingSAXErrorHandler;
import com.helger.xml.schema.XMLSchemaCache;
import com.helger.xml.transform.TransformSourceFactory;
import java.util.Locale;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class XMLSchemaValidationHelper {
    private static final XMLSchemaValidationHelper INSTANCE = new XMLSchemaValidationHelper();

    private XMLSchemaValidationHelper() {
    }

    public static @NonNull IErrorList validate(@NonNull IReadableResource iReadableResource, @NonNull IReadableResource iReadableResource2) {
        return XMLSchemaValidationHelper.validate(new IReadableResource[]{iReadableResource}, iReadableResource2);
    }

    public static @NonNull IErrorList validate(@NonNull @Nonempty IReadableResource[] iReadableResourceArray, @NonNull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"XML");
        return XMLSchemaValidationHelper.validate(iReadableResourceArray, (Source)TransformSourceFactory.create(iReadableResource));
    }

    public static @NonNull IErrorList validate(@NonNull Schema schema, @NonNull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"XML");
        return XMLSchemaValidationHelper.validate(schema, (Source)TransformSourceFactory.create(iReadableResource));
    }

    public static @NonNull IErrorList validate(@NonNull @Nonempty IReadableResource iReadableResource, @NonNull Source source) {
        return XMLSchemaValidationHelper.validate(new IReadableResource[]{iReadableResource}, source);
    }

    public static @NonNull IErrorList validate(@NonNull @Nonempty IReadableResource[] iReadableResourceArray, @NonNull Source source) {
        return XMLSchemaValidationHelper.validate(XMLSchemaCache.getInstance().getSchema(iReadableResourceArray), source);
    }

    public static @NonNull IErrorList validate(@NonNull Schema schema, @NonNull Source source) {
        ErrorList errorList = new ErrorList();
        XMLSchemaValidationHelper.validate(schema, source, errorList);
        return errorList;
    }

    public static void validate(@NonNull Schema schema, @NonNull Source source, @NonNull ErrorList errorList) {
        XMLSchemaValidationHelper.validate(schema, source, errorList, null);
    }

    public static void validate(@NonNull Schema schema, @NonNull Source source, @NonNull ErrorList errorList, @Nullable Locale locale) {
        ValueEnforcer.notNull((Object)schema, (String)"Schema");
        ValueEnforcer.notNull((Object)source, (String)"XML");
        ValueEnforcer.notNull((Object)errorList, (String)"ErrorList");
        Validator validator = schema.newValidator();
        if (locale != null) {
            EXMLParserProperty.GENERAL_LOCALE.applyTo(validator, (Object)locale);
        }
        validator.setErrorHandler(new WrappedCollectingSAXErrorHandler(errorList));
        try {
            validator.validate(source, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to validate the XML " + String.valueOf(source) + " against " + String.valueOf(schema), exception);
        }
    }
}

