/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsEnumMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.xml.XMLFactory;
import com.helger.xml.dom.EXMLDOMFeature;
import com.helger.xml.dom.EXMLDOMFeatureVersion;
import com.helger.xml.dom.EXMLDOMNodeType;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;

public final class XMLDebug {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLDebug.class);
    private static final ICommonsMap<EXMLDOMFeatureVersion, ICommonsList<String>> SUPPORTED_FEATURES = new CommonsEnumMap(EXMLDOMFeatureVersion.class);
    private static final XMLDebug INSTANCE;

    private static void _initFeature(@NonNull EXMLDOMFeature eXMLDOMFeature) {
        DOMImplementation dOMImplementation = XMLFactory.getDOMImplementation();
        for (EXMLDOMFeatureVersion eXMLDOMFeatureVersion : EXMLDOMFeatureVersion.values()) {
            if (dOMImplementation.hasFeature(eXMLDOMFeature.getID(), eXMLDOMFeatureVersion.getID())) {
                ((ICommonsList)SUPPORTED_FEATURES.get((Object)eXMLDOMFeatureVersion)).add((Object)eXMLDOMFeature.getID());
                continue;
            }
            if (!dOMImplementation.hasFeature(eXMLDOMFeature.getPlusFeature(), eXMLDOMFeatureVersion.getID())) continue;
            ((ICommonsList)SUPPORTED_FEATURES.get((Object)eXMLDOMFeatureVersion)).add((Object)eXMLDOMFeature.getPlusFeature());
        }
    }

    private XMLDebug() {
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsMap<EXMLDOMFeatureVersion, ICommonsList<String>> getAllSupportedFeatures() {
        return (ICommonsMap)SUPPORTED_FEATURES.getClone();
    }

    @ReturnsMutableCopy
    public static @Nullable ICommonsList<String> getAllSupportedFeatures(@NonNull EXMLDOMFeatureVersion eXMLDOMFeatureVersion) {
        ICommonsList iCommonsList = (ICommonsList)SUPPORTED_FEATURES.get((Object)eXMLDOMFeatureVersion);
        return iCommonsList == null ? null : (ICommonsList)iCommonsList.getClone();
    }

    public static void debugLogDOMFeatures() {
        for (Map.Entry entry : SUPPORTED_FEATURES.entrySet()) {
            for (String string : (ICommonsList)entry.getValue()) {
                LOGGER.info("DOM " + ((EXMLDOMFeatureVersion)((Object)entry.getKey())).getID() + " feature '" + string + "' is present");
            }
        }
    }

    public static @NonNull String getNodeTypeAsString(int n) {
        EXMLDOMNodeType eXMLDOMNodeType = EXMLDOMNodeType.getFromIDOrNull(n);
        if (eXMLDOMNodeType != null) {
            return eXMLDOMNodeType.name();
        }
        LOGGER.warn("Unknown Node type " + n);
        return Integer.toString(n);
    }

    static {
        for (EXMLDOMFeatureVersion eXMLDOMFeatureVersion : EXMLDOMFeatureVersion.values()) {
            SUPPORTED_FEATURES.put((Object)eXMLDOMFeatureVersion, (Object)new CommonsArrayList());
        }
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_CORE);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_XML);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_UI_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_MOUSE_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_TEXT_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_KEYBOARD_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_MUTATION_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_MUTATION_NAME_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_HTML_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_LS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_LS_ASYNC);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_VALIDATION);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_XPATH);
        INSTANCE = new XMLDebug();
    }
}

