/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.read;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.callback.CallbackList;
import com.helger.base.callback.exception.IExceptionCallback;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsEnumMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.EXMLParserProperty;
import com.helger.xml.serialize.read.DOMReaderDefaultSettings;
import com.helger.xml.serialize.read.IDOMReaderSettings;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

@NotThreadSafe
public class DOMReaderSettings
implements ICloneable<DOMReaderSettings>,
IDOMReaderSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(DOMReaderSettings.class);
    private boolean m_bNamespaceAware;
    private boolean m_bValidating;
    private boolean m_bIgnoringElementContentWhitespace;
    private boolean m_bExpandEntityReferences;
    private boolean m_bIgnoringComments;
    private boolean m_bCoalescing;
    private Schema m_aSchema;
    private boolean m_bXIncludeAware;
    private final ICommonsMap<EXMLParserProperty, Object> m_aProperties = new CommonsEnumMap(EXMLParserProperty.class);
    private final ICommonsMap<EXMLParserFeature, Boolean> m_aFeatures = new CommonsEnumMap(EXMLParserFeature.class);
    private EntityResolver m_aEntityResolver;
    private ErrorHandler m_aErrorHandler;
    private final CallbackList<IExceptionCallback<Throwable>> m_aExceptionCallbacks = new CallbackList();
    private boolean m_bRequiresNewXMLParserExplicitly;

    public DOMReaderSettings() {
        this.setNamespaceAware(DOMReaderDefaultSettings.isNamespaceAware());
        this.setValidating(DOMReaderDefaultSettings.isValidating());
        this.setIgnoringElementContentWhitespace(DOMReaderDefaultSettings.isIgnoringElementContentWhitespace());
        this.setExpandEntityReferences(DOMReaderDefaultSettings.isExpandEntityReferences());
        this.setIgnoringComments(DOMReaderDefaultSettings.isIgnoringComments());
        this.setCoalescing(DOMReaderDefaultSettings.isCoalescing());
        this.setSchema(DOMReaderDefaultSettings.getSchema());
        this.setXIncludeAware(DOMReaderDefaultSettings.isXIncludeAware());
        this.setPropertyValues((Map<EXMLParserProperty, ?>)DOMReaderDefaultSettings.getAllPropertyValues());
        this.setFeatureValues((Map<EXMLParserFeature, Boolean>)DOMReaderDefaultSettings.getAllFeatureValues());
        this.setEntityResolver(DOMReaderDefaultSettings.getEntityResolver());
        this.setErrorHandler(DOMReaderDefaultSettings.getErrorHandler());
        this.exceptionCallbacks().set(DOMReaderDefaultSettings.exceptionCallbacks());
        this.setRequiresNewXMLParserExplicitly(DOMReaderDefaultSettings.isRequiresNewXMLParserExplicitly());
    }

    public DOMReaderSettings(@NonNull IDOMReaderSettings iDOMReaderSettings) {
        ValueEnforcer.notNull((Object)iDOMReaderSettings, (String)"Other");
        this.setNamespaceAware(iDOMReaderSettings.isNamespaceAware());
        this.setValidating(iDOMReaderSettings.isValidating());
        this.setIgnoringElementContentWhitespace(iDOMReaderSettings.isIgnoringElementContentWhitespace());
        this.setExpandEntityReferences(iDOMReaderSettings.isExpandEntityReferences());
        this.setIgnoringComments(iDOMReaderSettings.isIgnoringComments());
        this.setCoalescing(iDOMReaderSettings.isCoalescing());
        this.setSchema(iDOMReaderSettings.getSchema());
        this.setXIncludeAware(iDOMReaderSettings.isXIncludeAware());
        this.setPropertyValues((Map<EXMLParserProperty, ?>)iDOMReaderSettings.getAllPropertyValues());
        this.setFeatureValues((Map<EXMLParserFeature, Boolean>)iDOMReaderSettings.getAllFeatureValues());
        this.setEntityResolver(iDOMReaderSettings.getEntityResolver());
        this.setErrorHandler(iDOMReaderSettings.getErrorHandler());
        this.exceptionCallbacks().set(iDOMReaderSettings.exceptionCallbacks());
        this.setRequiresNewXMLParserExplicitly(iDOMReaderSettings.isRequiresNewXMLParserExplicitly());
    }

    @Override
    public boolean isNamespaceAware() {
        return this.m_bNamespaceAware;
    }

    public final @NonNull DOMReaderSettings setNamespaceAware(boolean bl) {
        this.m_bNamespaceAware = bl;
        return this;
    }

    @Override
    public boolean isValidating() {
        return this.m_bValidating;
    }

    public final @NonNull DOMReaderSettings setValidating(boolean bl) {
        this.m_bValidating = bl;
        return this;
    }

    @Override
    public boolean isIgnoringElementContentWhitespace() {
        return this.m_bIgnoringElementContentWhitespace;
    }

    public final @NonNull DOMReaderSettings setIgnoringElementContentWhitespace(boolean bl) {
        this.m_bIgnoringElementContentWhitespace = bl;
        return this;
    }

    @Override
    public boolean isExpandEntityReferences() {
        return this.m_bExpandEntityReferences;
    }

    public final @NonNull DOMReaderSettings setExpandEntityReferences(boolean bl) {
        this.m_bExpandEntityReferences = bl;
        return this;
    }

    @Override
    public boolean isIgnoringComments() {
        return this.m_bIgnoringComments;
    }

    public final @NonNull DOMReaderSettings setIgnoringComments(boolean bl) {
        this.m_bIgnoringComments = bl;
        return this;
    }

    @Override
    public boolean isCoalescing() {
        return this.m_bCoalescing;
    }

    public final @NonNull DOMReaderSettings setCoalescing(boolean bl) {
        this.m_bCoalescing = bl;
        return this;
    }

    @Override
    public @Nullable Schema getSchema() {
        return this.m_aSchema;
    }

    public final @NonNull DOMReaderSettings setSchema(@Nullable Schema schema) {
        this.m_aSchema = schema;
        return this;
    }

    @Override
    public boolean isXIncludeAware() {
        return this.m_bXIncludeAware;
    }

    public final @NonNull DOMReaderSettings setXIncludeAware(boolean bl) {
        this.m_bXIncludeAware = bl;
        return this;
    }

    @Override
    public boolean hasAnyProperties() {
        return this.m_aProperties.isNotEmpty();
    }

    @Override
    public @Nullable Object getPropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        return eXMLParserProperty == null ? null : this.m_aProperties.get((Object)eXMLParserProperty);
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsMap<EXMLParserProperty, Object> getAllPropertyValues() {
        return (ICommonsMap)this.m_aProperties.getClone();
    }

    public final @NonNull DOMReaderSettings setPropertyValue(@NonNull EXMLParserProperty eXMLParserProperty, @Nullable Object object) {
        ValueEnforcer.notNull((Object)((Object)eXMLParserProperty), (String)"Property");
        if (object != null && eXMLParserProperty.getValueClass() != null && !eXMLParserProperty.getValueClass().isAssignableFrom(object.getClass())) {
            LOGGER.warn("Setting the XML parser property '" + String.valueOf((Object)eXMLParserProperty) + "' to a value of " + String.valueOf(object.getClass()) + " will most likely not be interpreted!");
        }
        if (object != null) {
            this.m_aProperties.put((Object)eXMLParserProperty, object);
        } else {
            this.m_aProperties.remove((Object)eXMLParserProperty);
        }
        return this;
    }

    public final @NonNull DOMReaderSettings setPropertyValues(@Nullable Map<EXMLParserProperty, ?> map) {
        if (map != null) {
            this.m_aProperties.putAll(map);
        }
        return this;
    }

    public final @NonNull DOMReaderSettings removePropertyValue(@Nullable EXMLParserProperty eXMLParserProperty) {
        if (eXMLParserProperty != null) {
            this.m_aProperties.removeObject((Object)eXMLParserProperty);
        }
        return this;
    }

    public final @NonNull DOMReaderSettings removeAllPropertyValues() {
        this.m_aProperties.removeAll();
        return this;
    }

    @Override
    public @Nullable Locale getLocale() {
        return (Locale)this.getPropertyValue(EXMLParserProperty.GENERAL_LOCALE);
    }

    public @NonNull DOMReaderSettings setLocale(@Nullable Locale locale) {
        return this.setPropertyValue(EXMLParserProperty.GENERAL_LOCALE, locale);
    }

    @Override
    public boolean hasAnyFeature() {
        return this.m_aFeatures.isNotEmpty();
    }

    @Override
    public @Nullable Boolean getFeatureValue(@Nullable EXMLParserFeature eXMLParserFeature) {
        return eXMLParserFeature == null ? null : (Boolean)this.m_aFeatures.get((Object)eXMLParserFeature);
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsMap<EXMLParserFeature, Boolean> getAllFeatureValues() {
        return (ICommonsMap)this.m_aFeatures.getClone();
    }

    public final @NonNull DOMReaderSettings setFeatureValue(@NonNull EXMLParserFeature eXMLParserFeature, boolean bl) {
        ValueEnforcer.notNull((Object)((Object)eXMLParserFeature), (String)"Feature");
        this.m_aFeatures.put((Object)eXMLParserFeature, (Object)bl);
        return this;
    }

    public final @NonNull DOMReaderSettings setFeatureValue(@NonNull EXMLParserFeature eXMLParserFeature, @Nullable Boolean bl) {
        ValueEnforcer.notNull((Object)((Object)eXMLParserFeature), (String)"Feature");
        if (bl == null) {
            this.m_aFeatures.remove((Object)eXMLParserFeature);
        } else {
            this.m_aFeatures.put((Object)eXMLParserFeature, (Object)bl);
        }
        return this;
    }

    public final @NonNull DOMReaderSettings setFeatureValues(@Nullable Map<EXMLParserFeature, Boolean> map) {
        if (map != null) {
            this.m_aFeatures.putAll(map);
        }
        return this;
    }

    public final @NonNull DOMReaderSettings removeFeature(@Nullable EXMLParserFeature eXMLParserFeature) {
        if (eXMLParserFeature != null) {
            this.m_aFeatures.removeObject((Object)eXMLParserFeature);
        }
        return this;
    }

    public final @NonNull DOMReaderSettings removeFeatures(EXMLParserFeature ... eXMLParserFeatureArray) {
        if (eXMLParserFeatureArray != null) {
            for (EXMLParserFeature eXMLParserFeature : eXMLParserFeatureArray) {
                this.m_aFeatures.removeObject((Object)eXMLParserFeature);
            }
        }
        return this;
    }

    public final @NonNull DOMReaderSettings removeAllFeatures() {
        this.m_aFeatures.removeAll();
        return this;
    }

    @Override
    public boolean requiresNewXMLParser() {
        if (this.m_bRequiresNewXMLParserExplicitly) {
            return true;
        }
        if (!this.m_bNamespaceAware || this.m_bValidating || this.m_bIgnoringElementContentWhitespace || !this.m_bExpandEntityReferences || !this.m_bIgnoringComments || !this.m_bCoalescing || this.m_aSchema != null || this.m_bXIncludeAware || this.m_aProperties.isNotEmpty() || this.m_aFeatures.isNotEmpty()) {
            return true;
        }
        return this.m_aEntityResolver != null;
    }

    @Override
    public @Nullable EntityResolver getEntityResolver() {
        return this.m_aEntityResolver;
    }

    public final @NonNull DOMReaderSettings setEntityResolver(@Nullable EntityResolver entityResolver) {
        this.m_aEntityResolver = entityResolver;
        return this;
    }

    @Override
    public @Nullable ErrorHandler getErrorHandler() {
        return this.m_aErrorHandler;
    }

    public final @NonNull DOMReaderSettings setErrorHandler(@Nullable ErrorHandler errorHandler) {
        this.m_aErrorHandler = errorHandler;
        return this;
    }

    @Override
    public @NonNull CallbackList<IExceptionCallback<Throwable>> exceptionCallbacks() {
        return this.m_aExceptionCallbacks;
    }

    @Override
    public boolean isRequiresNewXMLParserExplicitly() {
        return this.m_bRequiresNewXMLParserExplicitly;
    }

    public final @NonNull DOMReaderSettings setRequiresNewXMLParserExplicitly(boolean bl) {
        this.m_bRequiresNewXMLParserExplicitly = bl;
        return this;
    }

    public @NonNull DOMReaderSettings getClone() {
        return new DOMReaderSettings(this);
    }

    @Override
    public void applyToDocumentBuilderFactory(@NonNull DocumentBuilderFactory documentBuilderFactory) {
        ValueEnforcer.notNull((Object)documentBuilderFactory, (String)"DocumentBuilderFactory");
        documentBuilderFactory.setNamespaceAware(this.isNamespaceAware());
        documentBuilderFactory.setValidating(this.isValidating());
        documentBuilderFactory.setIgnoringElementContentWhitespace(this.isIgnoringElementContentWhitespace());
        documentBuilderFactory.setExpandEntityReferences(this.isExpandEntityReferences());
        documentBuilderFactory.setIgnoringComments(this.isIgnoringComments());
        documentBuilderFactory.setCoalescing(this.isCoalescing());
        try {
            documentBuilderFactory.setSchema(this.getSchema());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOGGER.warn("DocumentBuilderFactory does not support XML Schema: " + unsupportedOperationException.getMessage());
        }
        try {
            documentBuilderFactory.setXIncludeAware(this.isXIncludeAware());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOGGER.warn("DocumentBuilderFactory does not support XInclude setting: " + unsupportedOperationException.getMessage());
        }
        if (this.hasAnyProperties()) {
            for (Map.Entry entry : this.getAllPropertyValues().entrySet()) {
                ((EXMLParserProperty)((Object)entry.getKey())).applyTo(documentBuilderFactory, entry.getValue());
            }
        }
        if (this.hasAnyFeature()) {
            for (Map.Entry entry : this.getAllFeatureValues().entrySet()) {
                ((EXMLParserFeature)((Object)entry.getKey())).applyTo(documentBuilderFactory, (boolean)((Boolean)entry.getValue()));
            }
        }
    }

    @Override
    public void applyToDocumentBuilder(@NonNull DocumentBuilder documentBuilder) {
        ValueEnforcer.notNull((Object)documentBuilder, (String)"DocumentBuilder");
        documentBuilder.setErrorHandler(this.getErrorHandler());
        documentBuilder.setEntityResolver(this.getEntityResolver());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("namespaceAware", this.m_bNamespaceAware).append("validating", this.m_bValidating).append("ignoringElementContentWhitespace", this.m_bIgnoringElementContentWhitespace).append("expandEntityReferences", this.m_bExpandEntityReferences).append("ignoringComments", this.m_bIgnoringComments).append("coalescing", this.m_bCoalescing).append("schema", (Object)this.m_aSchema).append("XIncludeAware", this.m_bXIncludeAware).append("properties", this.m_aProperties).append("features", this.m_aFeatures).append("entityResolver", (Object)this.m_aEntityResolver).append("errorHandler", (Object)this.m_aErrorHandler).append("exceptionCallbacks", this.m_aExceptionCallbacks).append("requiresNewXMLParserExplicitly", this.m_bRequiresNewXMLParserExplicitly).getToString();
    }
}

