/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.xml.CXMLRegEx;
import com.helger.xml.microdom.IMicroQName;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class MicroQName
implements IMicroQName {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroQName.class);
    private final String m_sNamespaceURI;
    private final String m_sName;
    private int m_nHashCode = 0;

    public MicroQName(@Nonempty @NonNull String string) {
        this("", string);
    }

    public MicroQName(@Nullable String string, @Nonempty @NonNull String string2) {
        int n;
        ValueEnforcer.notEmpty((CharSequence)string2, (String)string2);
        this.m_sNamespaceURI = StringHelper.isEmpty((String)string) ? null : string;
        int n2 = n = this.m_sNamespaceURI != null ? string2.indexOf(58) : -1;
        if (n == -1) {
            this.m_sName = string2;
        } else {
            LOGGER.warn("Removing namespace prefix '" + string2.substring(0, n) + "' from micro XML name '" + string2 + "'");
            this.m_sName = string2.substring(n + 1);
        }
        if (GlobalDebug.isDebugMode() && !CXMLRegEx.PATTERN_NAME_QUICK.matcher(this.m_sName).matches() && !CXMLRegEx.PATTERN_NAME.matcher(this.m_sName).matches()) {
            throw new IllegalArgumentException("The micro XML name '" + this.m_sName + "' is not a valid XML name!");
        }
    }

    @Override
    public @Nullable String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Override
    @Nonempty
    public @NonNull String getName() {
        return this.m_sName;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MicroQName microQName = (MicroQName)object;
        return EqualsHelper.equals((Object)this.m_sNamespaceURI, (Object)microQName.m_sNamespaceURI) && this.m_sName.equals(microQName.m_sName);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator((Object)this).append((Object)this.m_sNamespaceURI).append((Object)this.m_sName).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator(null).appendIfNotNull("NamespaceURI", (Object)this.m_sNamespaceURI).append("Name", (Object)this.m_sName).getToString();
    }
}

