/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ETriState;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsList;
import com.helger.xml.microdom.AbstractMicroNode;
import com.helger.xml.microdom.AbstractMicroNodeWithChildren;
import com.helger.xml.microdom.EMicroNodeType;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroDocumentType;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class MicroDocument
extends AbstractMicroNodeWithChildren
implements IMicroDocument {
    public static final ETriState DEFAULT_STANDALONE = ETriState.UNDEFINED;
    private ETriState m_eStandalone = DEFAULT_STANDALONE;

    public MicroDocument() {
    }

    public MicroDocument(@Nullable IMicroDocumentType iMicroDocumentType) {
        if (iMicroDocumentType != null) {
            this.addChild(iMicroDocumentType);
        }
    }

    @Override
    public @NonNull EMicroNodeType getType() {
        return EMicroNodeType.DOCUMENT;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    private static boolean _canBeAppendedToDocumentRoot(@NonNull IMicroNode iMicroNode) {
        return iMicroNode.isDocumentType() || iMicroNode.isProcessingInstruction() || iMicroNode.isComment() || iMicroNode.isElement();
    }

    @Override
    protected void onAddChild(@NonNull AbstractMicroNode abstractMicroNode) {
        ICommonsList<IMicroNode> iCommonsList;
        if (!MicroDocument._canBeAppendedToDocumentRoot(abstractMicroNode)) {
            throw new MicroException("Cannot add nodes of type " + String.valueOf(abstractMicroNode) + " to a document");
        }
        if (abstractMicroNode.isElement() && (iCommonsList = this.directGetAllChildren()) != null && iCommonsList.isNotEmpty()) {
            for (IMicroNode iMicroNode : iCommonsList) {
                if (!iMicroNode.isElement()) continue;
                throw new MicroException("A document can only have one document element! Already has " + String.valueOf(iMicroNode) + " and wants to add " + String.valueOf(abstractMicroNode));
            }
        }
        super.onAddChild(abstractMicroNode);
    }

    @Override
    public @NonNull ETriState getStandalone() {
        return this.m_eStandalone;
    }

    @Override
    public void setStandalone(@NonNull ETriState eTriState) {
        ValueEnforcer.notNull((Object)eTriState, (String)"Standalone");
        this.m_eStandalone = eTriState;
    }

    @Override
    public @Nullable IMicroDocumentType getDocType() {
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetAllChildren()) {
                if (!iMicroNode.isDocumentType()) continue;
                return (IMicroDocumentType)iMicroNode;
            }
        }
        return null;
    }

    @Override
    public @Nullable IMicroElement getDocumentElement() {
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetAllChildren()) {
                if (!iMicroNode.isElement()) continue;
                return (IMicroElement)iMicroNode;
            }
        }
        return null;
    }

    @Override
    public @NonNull IMicroDocument getClone() {
        MicroDocument microDocument = new MicroDocument();
        microDocument.setStandalone(this.m_eStandalone);
        this.forAllChildren(iMicroNode -> microDocument.addChild((IMicroNode)iMicroNode.getClone()));
        return microDocument;
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (!super.isEqualContent(iMicroNode)) {
            return false;
        }
        MicroDocument microDocument = (MicroDocument)iMicroNode;
        return this.m_eStandalone == microDocument.m_eStandalone;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Standalone", (Enum)this.m_eStandalone).getToString();
    }
}

