/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.callback.CallbackList;
import com.helger.base.callback.ICallback;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.state.EContinue;
import com.helger.base.state.IChangeIndicator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsEnumMap;
import com.helger.collection.commons.ICommonsIterable;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.xml.microdom.AbstractMicroNodeWithChildren;
import com.helger.xml.microdom.EMicroEvent;
import com.helger.xml.microdom.IMicroCDATA;
import com.helger.xml.microdom.IMicroComment;
import com.helger.xml.microdom.IMicroContainer;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroDocumentType;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroEntityReference;
import com.helger.xml.microdom.IMicroEvent;
import com.helger.xml.microdom.IMicroEventTarget;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroProcessingInstruction;
import com.helger.xml.microdom.IMicroText;
import com.helger.xml.microdom.MicroEvent;
import com.helger.xml.microdom.MicroException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class AbstractMicroNode
implements IMicroNode {
    private AbstractMicroNodeWithChildren m_aParentNode;
    private CommonsEnumMap<EMicroEvent, CallbackList<IMicroEventTarget>> m_aEventTargets;

    @OverrideOnDemand
    protected void onAddChild(@NonNull AbstractMicroNode abstractMicroNode) {
        throw new MicroException("Cannot add children in class " + this.getClass().getName());
    }

    @OverrideOnDemand
    protected void onInsertBefore(@NonNull AbstractMicroNode abstractMicroNode, @NonNull IMicroNode iMicroNode) {
        throw new MicroException("Cannot insert children in class " + this.getClass().getName());
    }

    @OverrideOnDemand
    protected void onInsertAfter(@NonNull AbstractMicroNode abstractMicroNode, @NonNull IMicroNode iMicroNode) {
        throw new MicroException("Cannot insert children in class " + this.getClass().getName());
    }

    @OverrideOnDemand
    protected void onInsertAtIndex(@Nonnegative int n, @NonNull AbstractMicroNode abstractMicroNode) {
        throw new MicroException("Cannot insert children in class " + this.getClass().getName());
    }

    @Override
    public final <NODETYPE extends IMicroNode> @Nullable NODETYPE addChild(@Nullable NODETYPE NODETYPE) {
        if (NODETYPE != null) {
            this.onAddChild((AbstractMicroNode)NODETYPE);
        }
        return NODETYPE;
    }

    @Override
    public final <NODETYPE extends IMicroNode> @Nullable NODETYPE insertBefore(@Nullable NODETYPE NODETYPE, @NonNull IMicroNode iMicroNode) {
        if (NODETYPE != null) {
            this.onInsertBefore((AbstractMicroNode)NODETYPE, iMicroNode);
        }
        return NODETYPE;
    }

    @Override
    public final <NODETYPE extends IMicroNode> @Nullable NODETYPE insertAfter(@Nullable NODETYPE NODETYPE, @NonNull IMicroNode iMicroNode) {
        if (NODETYPE != null) {
            this.onInsertAfter((AbstractMicroNode)NODETYPE, iMicroNode);
        }
        return NODETYPE;
    }

    @Override
    public final <NODETYPE extends IMicroNode> @Nullable NODETYPE insertAtIndex(@Nonnegative int n, @Nullable NODETYPE NODETYPE) {
        if (NODETYPE != null) {
            this.onInsertAtIndex(n, (AbstractMicroNode)NODETYPE);
        }
        return NODETYPE;
    }

    @OverrideOnDemand
    protected @NonNull EChange onRemoveChild(IMicroNode iMicroNode) {
        throw new MicroException("Cannot remove child from this node: " + this.getClass().getName());
    }

    @Override
    public final @NonNull EChange removeChild(@NonNull IMicroNode iMicroNode) {
        ValueEnforcer.notNull((Object)iMicroNode, (String)"Child");
        return this.onRemoveChild(iMicroNode);
    }

    @OverrideOnDemand
    protected @NonNull EChange onRemoveChildAtIndex(int n) {
        throw new MicroException("Cannot remove child from this node: " + this.getClass().getName());
    }

    @Override
    public final @NonNull EChange removeChildAtIndex(@Nonnegative int n) {
        return this.onRemoveChildAtIndex(n);
    }

    @OverrideOnDemand
    protected @NonNull EChange onRemoveAllChildren() {
        throw new MicroException("Cannot remove all children from this node: " + this.getClass().getName());
    }

    @Override
    public final @NonNull EChange removeAllChildren() {
        return this.onRemoveAllChildren();
    }

    @OverrideOnDemand
    public boolean hasChildren() {
        return false;
    }

    @Override
    @OverrideOnDemand
    public @Nullable ICommonsList<IMicroNode> getAllChildren() {
        return null;
    }

    @OverrideOnDemand
    public @Nullable ICommonsIterable<IMicroNode> getChildren() {
        return null;
    }

    public void forAllChildren(@NonNull Consumer<? super IMicroNode> consumer) {
    }

    public @NonNull EContinue forAllChildrenBreakable(@NonNull Function<? super IMicroNode, EContinue> function) {
        return EContinue.CONTINUE;
    }

    public void forAllChildren(@NonNull Predicate<? super IMicroNode> predicate, @NonNull Consumer<? super IMicroNode> consumer) {
    }

    public <DSTTYPE> void forAllChildrenMapped(@NonNull Predicate<? super IMicroNode> predicate, @NonNull Function<? super IMicroNode, ? extends DSTTYPE> function, @NonNull Consumer<? super DSTTYPE> consumer) {
    }

    @OverrideOnDemand
    public @Nullable IMicroNode getChildAtIndex(@Nonnegative int n) {
        return null;
    }

    @Nonnegative
    @OverrideOnDemand
    public int getChildCount() {
        return 0;
    }

    @Override
    @OverrideOnDemand
    public @Nullable IMicroNode getFirstChild() {
        return null;
    }

    public @Nullable IMicroNode findFirstChild(@NonNull Predicate<? super IMicroNode> predicate) {
        return null;
    }

    public <DSTTYPE> @Nullable DSTTYPE findFirstChildMapped(@NonNull Predicate<? super IMicroNode> predicate, @NonNull Function<? super IMicroNode, ? extends DSTTYPE> function) {
        return null;
    }

    @Override
    @OverrideOnDemand
    public @Nullable IMicroNode getLastChild() {
        return null;
    }

    @Override
    public final @Nullable IMicroNode getPreviousSibling() {
        if (this.m_aParentNode == null) {
            return null;
        }
        ICommonsList<IMicroNode> iCommonsList = this.m_aParentNode.directGetAllChildren();
        int n = iCommonsList.indexOf((Object)this);
        if (n == -1) {
            throw new IllegalStateException("this is no part of it's parents children");
        }
        return (IMicroNode)iCommonsList.getAtIndex(n - 1);
    }

    @Override
    public final @Nullable IMicroNode getNextSibling() {
        if (this.m_aParentNode == null) {
            return null;
        }
        ICommonsList<IMicroNode> iCommonsList = this.m_aParentNode.directGetAllChildren();
        int n = iCommonsList.indexOf((Object)this);
        if (n == -1) {
            throw new IllegalStateException("this is no part of it's parents children");
        }
        return (IMicroNode)iCommonsList.getAtIndex(n + 1);
    }

    @Override
    public final boolean hasParent() {
        return this.m_aParentNode != null;
    }

    @Override
    public final @Nullable IMicroNode getParent() {
        return this.m_aParentNode;
    }

    protected final void internalResetParentNode() {
        this.m_aParentNode = null;
    }

    protected final void internalSetParentNode(@NonNull AbstractMicroNodeWithChildren abstractMicroNodeWithChildren) {
        if (abstractMicroNodeWithChildren == null) {
            throw new MicroException("No parent node passed!");
        }
        if (abstractMicroNodeWithChildren == this) {
            throw new MicroException("Node cannot have itself as parent: " + this.toString());
        }
        if (this.m_aParentNode != null) {
            throw new MicroException("Node already has a parent: " + this.toString());
        }
        this.m_aParentNode = abstractMicroNodeWithChildren;
    }

    @Override
    public final @NonNull IMicroNode detachFromParent() {
        if (this.m_aParentNode != null) {
            if (this.m_aParentNode.removeChild(this).isUnchanged()) {
                throw new IllegalStateException("Failed to remove this from parents child list");
            }
            this.internalResetParentNode();
        }
        return this;
    }

    @Override
    public @Nullable IMicroElement findParentElement(@NonNull Predicate<? super IMicroElement> predicate) {
        for (IMicroNode iMicroNode = this.m_aParentNode; iMicroNode != null && iMicroNode.isElement(); iMicroNode = iMicroNode.getParent()) {
            IMicroElement iMicroElement = (IMicroElement)iMicroNode;
            if (!predicate.test(iMicroElement)) continue;
            return iMicroElement;
        }
        return null;
    }

    @Override
    public final boolean isDocument() {
        return this instanceof IMicroDocument;
    }

    @Override
    public final boolean isDocumentType() {
        return this instanceof IMicroDocumentType;
    }

    @Override
    public final boolean isText() {
        return this instanceof IMicroText;
    }

    @Override
    public final boolean isCDATA() {
        return this instanceof IMicroCDATA;
    }

    @Override
    public final boolean isComment() {
        return this instanceof IMicroComment;
    }

    @Override
    public final boolean isEntityReference() {
        return this instanceof IMicroEntityReference;
    }

    @Override
    public final boolean isElement() {
        return this instanceof IMicroElement;
    }

    @Override
    public final boolean isProcessingInstruction() {
        return this instanceof IMicroProcessingInstruction;
    }

    @Override
    public final boolean isContainer() {
        return this instanceof IMicroContainer;
    }

    protected final void internalTriggerEvent(@NonNull EMicroEvent eMicroEvent, @NonNull IMicroEvent iMicroEvent) {
        CallbackList callbackList;
        if (this.m_aEventTargets != null && this.m_aEventTargets.isNotEmpty() && (callbackList = (CallbackList)this.m_aEventTargets.get((Object)eMicroEvent)) != null) {
            callbackList.forEach(iMicroEventTarget -> iMicroEventTarget.handleEvent(iMicroEvent));
        }
        if (this.m_aParentNode != null) {
            this.m_aParentNode.internalTriggerEvent(eMicroEvent, iMicroEvent);
        }
    }

    protected final void onEvent(@NonNull EMicroEvent eMicroEvent, @NonNull IMicroNode iMicroNode, @NonNull IMicroNode iMicroNode2) {
        this.internalTriggerEvent(eMicroEvent, new MicroEvent(eMicroEvent, iMicroNode, iMicroNode2));
    }

    @Override
    public @NonNull EChange registerEventTarget(@NonNull EMicroEvent eMicroEvent2, @NonNull IMicroEventTarget iMicroEventTarget) {
        ValueEnforcer.notNull((Object)((Object)eMicroEvent2), (String)"EventType");
        ValueEnforcer.notNull((Object)iMicroEventTarget, (String)"EventTarget");
        if (this.m_aEventTargets == null) {
            this.m_aEventTargets = new CommonsEnumMap(EMicroEvent.class);
        }
        CallbackList callbackList = (CallbackList)this.m_aEventTargets.computeIfAbsent((Object)eMicroEvent2, eMicroEvent -> new CallbackList());
        return EChange.valueOf((IChangeIndicator)callbackList.add((ICallback)iMicroEventTarget));
    }

    @Override
    public @NonNull EChange unregisterEventTarget(@NonNull EMicroEvent eMicroEvent, @NonNull IMicroEventTarget iMicroEventTarget) {
        CallbackList callbackList;
        ValueEnforcer.notNull((Object)((Object)eMicroEvent), (String)"EventType");
        ValueEnforcer.notNull((Object)iMicroEventTarget, (String)"EventTarget");
        if (this.m_aEventTargets != null && this.m_aEventTargets.isNotEmpty() && (callbackList = (CallbackList)this.m_aEventTargets.get((Object)eMicroEvent)) != null) {
            return callbackList.removeObject((ICallback)iMicroEventTarget);
        }
        return EChange.UNCHANGED;
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsMap<EMicroEvent, CallbackList<IMicroEventTarget>> getAllEventTargets() {
        return new CommonsEnumMap(this.m_aEventTargets);
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull CallbackList<IMicroEventTarget> getAllEventTargets(@Nullable EMicroEvent eMicroEvent) {
        return new CallbackList(this.m_aEventTargets == null ? null : (CallbackList)this.m_aEventTargets.get((Object)eMicroEvent));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("ParentNodeName", this.m_aParentNode == null ? null : this.m_aParentNode.getNodeName()).appendIfNotNull("EventTargets", this.m_aEventTargets).getToString();
    }
}

