/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.ls;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.classloader.IHasClassLoader;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resourceresolver.DefaultResourceResolver;
import com.helger.xml.ls.AbstractLSResourceResolver;
import com.helger.xml.ls.ResourceLSInput;
import java.lang.ref.WeakReference;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;

public class SimpleLSResourceResolver
extends AbstractLSResourceResolver
implements IHasClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleLSResourceResolver.class);
    private final WeakReference<ClassLoader> m_aClassLoader;

    public SimpleLSResourceResolver() {
        this(null);
    }

    public SimpleLSResourceResolver(@Nullable ClassLoader classLoader) {
        this.m_aClassLoader = new WeakReference<ClassLoader>(classLoader);
    }

    public @Nullable ClassLoader getClassLoader() {
        return (ClassLoader)this.m_aClassLoader.get();
    }

    @OverrideOnDemand
    protected @Nullable IReadableResource internalResolveResource(@Nonempty @NonNull String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5) throws Exception {
        return DefaultResourceResolver.getResolvedResource((String)string4, (String)string5, (ClassLoader)this.getClassLoader());
    }

    @Override
    public final @Nullable LSInput mainResolveResource(@Nonempty @NonNull String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5) {
        try {
            IReadableResource iReadableResource = this.internalResolveResource(string, string2, string3, string4, string5);
            return new ResourceLSInput(iReadableResource);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to resolve resource '" + string + "', '" + string2 + "', '" + string3 + "', '" + string4 + "', '" + string5 + "'", exception);
        }
    }
}

