/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.xml.microdom.AbstractMicroNode;
import com.helger.xml.microdom.EMicroNodeType;
import com.helger.xml.microdom.IMicroEntityReference;
import com.helger.xml.microdom.IMicroNode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public final class MicroEntityReference
extends AbstractMicroNode
implements IMicroEntityReference {
    private final String m_sName;

    public MicroEntityReference(@Nonnull @Nonempty String string) {
        this.m_sName = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"EntityReferenceName");
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.ENTITY_REFERENCE;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeName() {
        return "&" + this.m_sName + ";";
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeValue() {
        return this.getName();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public IMicroEntityReference getClone() {
        return new MicroEntityReference(this.m_sName);
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (iMicroNode == null || !this.getClass().equals(iMicroNode.getClass())) {
            return false;
        }
        MicroEntityReference microEntityReference = (MicroEntityReference)iMicroNode;
        return this.m_sName.equals(microEntityReference.m_sName);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("name", (Object)this.m_sName).getToString();
    }
}

