/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsIterableIterator;
import com.helger.collection.commons.ICommonsList;
import jakarta.annotation.Nonnull;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RecursiveNodeIterator
implements ICommonsIterableIterator<Node> {
    private final ICommonsList<Node> m_aOpen = new CommonsArrayList();

    public RecursiveNodeIterator(@Nonnull Node node) {
        ValueEnforcer.notNull((Object)node, (String)"Node");
        this.m_aOpen.add((Object)node);
    }

    public boolean hasNext() {
        return this.m_aOpen.isNotEmpty();
    }

    @Nonnull
    public Node next() {
        if (this.m_aOpen.isEmpty()) {
            throw new NoSuchElementException();
        }
        Node node = (Node)this.m_aOpen.remove(0);
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = nodeList.getLength();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                this.m_aOpen.add(n2, (Object)nodeList.item(i));
                ++n2;
            }
        }
        return node;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Open", this.m_aOpen).getToString();
    }

    @Nonnull
    public static RecursiveNodeIterator createChildNodeIterator(@Nonnull Node node) {
        RecursiveNodeIterator recursiveNodeIterator = new RecursiveNodeIterator(node);
        recursiveNodeIterator.next();
        return recursiveNodeIterator;
    }
}

