/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsIterableIterator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.NoSuchElementException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapIterator
implements ICommonsIterableIterator<Node> {
    private final NamedNodeMap m_aNL;
    private int m_nIndex = 0;
    private final int m_nMax;

    public NamedNodeMapIterator(@Nullable NamedNodeMap namedNodeMap) {
        this.m_aNL = namedNodeMap;
        this.m_nMax = namedNodeMap == null ? 0 : namedNodeMap.getLength();
    }

    public boolean hasNext() {
        return this.m_nIndex < this.m_nMax;
    }

    @Nullable
    public Node next() {
        if (this.m_nIndex >= this.m_nMax) {
            throw new NoSuchElementException();
        }
        Node node = this.m_aNL.item(this.m_nIndex);
        ++this.m_nIndex;
        return node;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("NamedNodeMap", (Object)this.m_aNL).append("Max", this.m_nMax).append("Index", this.m_nIndex).getToString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NamedNodeMapIterator createAttributeIterator(@Nullable Element element) {
        return new NamedNodeMapIterator(element == null ? null : element.getAttributes());
    }
}

