/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.write;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.CGlobal;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringReplace;
import com.helger.xml.EXMLVersion;
import com.helger.xml.serialize.write.EXMLCharMode;
import com.helger.xml.serialize.write.EXMLIncorrectCharacterHandling;
import com.helger.xml.serialize.write.EXMLSerializeVersion;
import com.helger.xml.serialize.write.XMLCharHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;

public final class XMLMaskHelper {
    private static final char TAB = '\t';
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char AMPERSAND = '&';
    private static final char LT = '<';
    private static final char GT = '>';
    private static final char APOS = '\'';
    private static final char[] MASK_ATTRIBUTE_VALUE_XML10_DQ;
    private static final char[] MASK_ATTRIBUTE_VALUE_XML10_SQ;
    private static final char[] MASK_TEXT_XML10;
    private static final char[] MASK_ATTRIBUTE_VALUE_XML11_DQ;
    private static final char[] MASK_ATTRIBUTE_VALUE_XML11_SQ;
    private static final char[] MASK_TEXT_XML11;
    private static final char[] MASK_TEXT_HTML_DQ;
    private static final char[] MASK_TEXT_HTML_SQ;
    private static final char[][] MASK_ATTRIBUTE_VALUE_XML10_DQ_REPLACE;
    private static final char[][] MASK_ATTRIBUTE_VALUE_XML10_SQ_REPLACE;
    private static final char[][] MASK_TEXT_XML10_REPLACE;
    private static final char[][] MASK_ATTRIBUTE_VALUE_XML11_DQ_REPLACE;
    private static final char[][] MASK_ATTRIBUTE_VALUE_XML11_SQ_REPLACE;
    private static final char[][] MASK_TEXT_XML11_REPLACE;
    private static final char[][] MASK_TEXT_HTML_DQ_REPLACE;
    private static final char[][] MASK_TEXT_HTML_SQ_REPLACE;
    private static final char[] INT_HEX_UC;
    private static final XMLMaskHelper INSTANCE;

    @Nonnull
    public static String getXMLNumericReference(char c) {
        StringBuilder stringBuilder = new StringBuilder(16);
        stringBuilder.append("&#x");
        if (c > '\u0fff') {
            stringBuilder.append(INT_HEX_UC[c >> 12 & 0xF]);
        }
        if (c > '\u00ff') {
            stringBuilder.append(INT_HEX_UC[c >> 8 & 0xF]);
        }
        if (c > '\u000f') {
            stringBuilder.append(INT_HEX_UC[c >> 4 & 0xF]);
        }
        stringBuilder.append(INT_HEX_UC[c & 0xF]);
        stringBuilder.append(';');
        return stringBuilder.toString();
    }

    @Nonnull
    @Nonempty
    public static String getXML10EntityReferenceString(char c) {
        if (c == '<') {
            return "&lt;";
        }
        if (c == '>') {
            return "&gt;";
        }
        if (c == '&') {
            return "&amp;";
        }
        if (c == '\"') {
            return "&quot;";
        }
        if (c == '\'') {
            return "&apos;";
        }
        return XMLMaskHelper.getXMLNumericReference(c);
    }

    @Nonnull
    @Nonempty
    public static String getXML11EntityReferenceString(char c) {
        if (c == '<') {
            return "&lt;";
        }
        if (c == '>') {
            return "&gt;";
        }
        if (c == '&') {
            return "&amp;";
        }
        if (c == '\"') {
            return "&quot;";
        }
        if (c == '\'') {
            return "&apos;";
        }
        if (c == '\u2028') {
            return "\n";
        }
        return XMLMaskHelper.getXMLNumericReference(c);
    }

    @Nonnull
    @Nonempty
    public static String getHTMLEntityReferenceString(char c) {
        if (c == '<') {
            return "&lt;";
        }
        if (c == '>') {
            return "&gt;";
        }
        if (c == '&') {
            return "&amp;";
        }
        if (c == '\"') {
            return "&quot;";
        }
        return "&#" + c + ";";
    }

    private XMLMaskHelper() {
    }

    @Nullable
    @ReturnsMutableObject(value="internal use only")
    private static char[] _findSourceMap(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nonnull EXMLCharMode eXMLCharMode) {
        switch (eXMLSerializeVersion) {
            case XML_10: {
                switch (eXMLCharMode) {
                    case ATTRIBUTE_VALUE_DOUBLE_QUOTES: {
                        return MASK_ATTRIBUTE_VALUE_XML10_DQ;
                    }
                    case ATTRIBUTE_VALUE_SINGLE_QUOTES: {
                        return MASK_ATTRIBUTE_VALUE_XML10_SQ;
                    }
                    case TEXT: {
                        return MASK_TEXT_XML10;
                    }
                }
                break;
            }
            case XML_11: {
                switch (eXMLCharMode) {
                    case ATTRIBUTE_VALUE_DOUBLE_QUOTES: {
                        return MASK_ATTRIBUTE_VALUE_XML11_DQ;
                    }
                    case ATTRIBUTE_VALUE_SINGLE_QUOTES: {
                        return MASK_ATTRIBUTE_VALUE_XML11_SQ;
                    }
                    case TEXT: {
                        return MASK_TEXT_XML11;
                    }
                }
                break;
            }
            case HTML: {
                switch (eXMLCharMode) {
                    case ATTRIBUTE_VALUE_SINGLE_QUOTES: {
                        return MASK_TEXT_HTML_SQ;
                    }
                    case ATTRIBUTE_VALUE_DOUBLE_QUOTES: 
                    case TEXT: {
                        return MASK_TEXT_HTML_DQ;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported XML version " + String.valueOf((Object)eXMLSerializeVersion) + "!");
            }
        }
        return null;
    }

    @Nullable
    @ReturnsMutableObject(value="internal use only")
    private static char[][] _findReplaceMap(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nonnull EXMLCharMode eXMLCharMode) {
        switch (eXMLSerializeVersion) {
            case XML_10: {
                switch (eXMLCharMode) {
                    case ATTRIBUTE_VALUE_DOUBLE_QUOTES: {
                        return MASK_ATTRIBUTE_VALUE_XML10_DQ_REPLACE;
                    }
                    case ATTRIBUTE_VALUE_SINGLE_QUOTES: {
                        return MASK_ATTRIBUTE_VALUE_XML10_SQ_REPLACE;
                    }
                    case TEXT: {
                        return MASK_TEXT_XML10_REPLACE;
                    }
                }
                break;
            }
            case XML_11: {
                switch (eXMLCharMode) {
                    case ATTRIBUTE_VALUE_DOUBLE_QUOTES: {
                        return MASK_ATTRIBUTE_VALUE_XML11_DQ_REPLACE;
                    }
                    case ATTRIBUTE_VALUE_SINGLE_QUOTES: {
                        return MASK_ATTRIBUTE_VALUE_XML11_SQ_REPLACE;
                    }
                    case TEXT: {
                        return MASK_TEXT_XML11_REPLACE;
                    }
                }
                break;
            }
            case HTML: {
                switch (eXMLCharMode) {
                    case ATTRIBUTE_VALUE_SINGLE_QUOTES: {
                        return MASK_TEXT_HTML_SQ_REPLACE;
                    }
                    case ATTRIBUTE_VALUE_DOUBLE_QUOTES: 
                    case TEXT: {
                        return MASK_TEXT_HTML_DQ_REPLACE;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported XML version " + String.valueOf((Object)eXMLSerializeVersion) + "!");
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    private static char[] _getAsCharArray(@Nonnull Set<Character> set) {
        ValueEnforcer.notNull(set, (String)"Chars");
        char[] cArray = new char[set.size()];
        int n = 0;
        for (Character c : set) {
            cArray[n++] = c.charValue();
        }
        return cArray;
    }

    @Nonnull
    @ReturnsMutableCopy
    private static char[][] _createEmptyReplacement(@Nonnull char[] cArray) {
        char[][] cArrayArray = new char[cArray.length][];
        for (int i = 0; i < cArray.length; ++i) {
            cArrayArray[i] = CGlobal.EMPTY_CHAR_ARRAY;
        }
        return cArrayArray;
    }

    @Nonnull
    public static char[] getMaskedXMLText(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nonnull EXMLCharMode eXMLCharMode, @Nonnull EXMLIncorrectCharacterHandling eXMLIncorrectCharacterHandling, @Nullable String string) {
        Object object;
        Object object2;
        if (StringHelper.isEmpty((String)string)) {
            return CGlobal.EMPTY_CHAR_ARRAY;
        }
        char[] cArray = string.toCharArray();
        if (eXMLIncorrectCharacterHandling.isTestRequired() && XMLCharHelper.containsInvalidXMLChar(eXMLSerializeVersion, eXMLCharMode, cArray)) {
            object2 = XMLCharHelper.getAllInvalidXMLChars(eXMLSerializeVersion, eXMLCharMode, cArray);
            eXMLIncorrectCharacterHandling.notifyOnInvalidXMLCharacter(string, (Set<Character>)object2);
            if (eXMLIncorrectCharacterHandling.isReplaceWithNothing()) {
                object = XMLMaskHelper._getAsCharArray((Set<Character>)object2);
                char[][] cArray2 = XMLMaskHelper._createEmptyReplacement((char[])object);
                cArray = StringReplace.replaceMultiple((String)string, (char[])object, (char[][])cArray2);
            }
        }
        if ((object2 = XMLMaskHelper._findSourceMap(eXMLSerializeVersion, eXMLCharMode)) == null) {
            return cArray;
        }
        object = XMLMaskHelper._findReplaceMap(eXMLSerializeVersion, eXMLCharMode);
        return StringReplace.replaceMultiple((char[])cArray, (char[])object2, (char[][])object);
    }

    @Nonnegative
    public static int getMaskedXMLTextLength(@Nonnull EXMLVersion eXMLVersion, @Nonnull EXMLCharMode eXMLCharMode, @Nonnull EXMLIncorrectCharacterHandling eXMLIncorrectCharacterHandling, @Nullable String string) {
        return XMLMaskHelper.getMaskedXMLTextLength(EXMLSerializeVersion.getFromXMLVersionOrThrow(eXMLVersion), eXMLCharMode, eXMLIncorrectCharacterHandling, string);
    }

    @Nonnegative
    public static int getMaskedXMLTextLength(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nonnull EXMLCharMode eXMLCharMode, @Nonnull EXMLIncorrectCharacterHandling eXMLIncorrectCharacterHandling, @Nullable String string) {
        int n;
        char[][] cArray;
        Object object;
        if (StringHelper.isEmpty((String)string)) {
            return 0;
        }
        char[] cArray2 = string.toCharArray();
        if (eXMLIncorrectCharacterHandling.isTestRequired() && XMLCharHelper.containsInvalidXMLChar(eXMLSerializeVersion, eXMLCharMode, cArray2)) {
            object = XMLCharHelper.getAllInvalidXMLChars(eXMLSerializeVersion, eXMLCharMode, cArray2);
            eXMLIncorrectCharacterHandling.notifyOnInvalidXMLCharacter(string, (Set<Character>)object);
            if (eXMLIncorrectCharacterHandling.isReplaceWithNothing()) {
                char[] cArray3 = XMLMaskHelper._getAsCharArray((Set<Character>)object);
                cArray = XMLMaskHelper._createEmptyReplacement(cArray3);
                cArray2 = StringReplace.replaceMultiple((String)string, (char[])cArray3, (char[][])cArray);
            }
        }
        int n2 = (object = XMLMaskHelper._findSourceMap(eXMLSerializeVersion, eXMLCharMode)) != null ? ((n = StringReplace.getReplaceMultipleResultLength((char[])cArray2, (char[])object, (char[][])(cArray = XMLMaskHelper._findReplaceMap(eXMLSerializeVersion, eXMLCharMode)))) == -1 ? cArray2.length : n) : cArray2.length;
        return n2;
    }

    public static void maskXMLTextTo(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nonnull EXMLCharMode eXMLCharMode, @Nonnull EXMLIncorrectCharacterHandling eXMLIncorrectCharacterHandling, @Nullable String string, @Nonnull Writer writer) throws IOException {
        if (StringHelper.isNotEmpty((String)string)) {
            XMLMaskHelper.maskXMLTextTo(eXMLSerializeVersion, eXMLCharMode, eXMLIncorrectCharacterHandling, string.toCharArray(), 0, string.length(), writer);
        }
    }

    public static void maskXMLTextTo(@Nonnull EXMLSerializeVersion eXMLSerializeVersion, @Nonnull EXMLCharMode eXMLCharMode, @Nonnull EXMLIncorrectCharacterHandling eXMLIncorrectCharacterHandling, @Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Writer writer) throws IOException {
        Object object;
        Object object2;
        if (n2 == 0) {
            return;
        }
        char[] cArray2 = cArray;
        int n3 = n;
        int n4 = n2;
        if (eXMLIncorrectCharacterHandling.isTestRequired() && XMLCharHelper.containsInvalidXMLChar(eXMLSerializeVersion, eXMLCharMode, cArray2, n3, n4)) {
            object2 = XMLCharHelper.getAllInvalidXMLChars(eXMLSerializeVersion, eXMLCharMode, cArray2, n3, n4);
            object = new String(cArray, n3, n4);
            eXMLIncorrectCharacterHandling.notifyOnInvalidXMLCharacter((String)object, (Set<Character>)object2);
            if (eXMLIncorrectCharacterHandling.isReplaceWithNothing()) {
                char[] cArray3 = XMLMaskHelper._getAsCharArray((Set<Character>)object2);
                char[][] cArray4 = XMLMaskHelper._createEmptyReplacement(cArray3);
                cArray2 = StringReplace.replaceMultiple((String)object, (char[])cArray3, (char[][])cArray4);
                n3 = 0;
                n4 = cArray2.length;
                if (n4 == 0) {
                    return;
                }
            }
        }
        if ((object2 = XMLMaskHelper._findSourceMap(eXMLSerializeVersion, eXMLCharMode)) == null) {
            writer.write(cArray2, n3, n4);
        } else {
            object = XMLMaskHelper._findReplaceMap(eXMLSerializeVersion, eXMLCharMode);
            StringReplace.replaceMultipleTo((char[])cArray2, (int)n3, (int)n4, (char[])object2, (char[][])object, (Writer)writer);
        }
    }

    static {
        int n;
        MASK_ATTRIBUTE_VALUE_XML10_DQ = new char[]{'\t', '\n', '\r', '\"', '&', '<'};
        MASK_ATTRIBUTE_VALUE_XML10_SQ = new char[]{'\t', '\n', '\r', '\'', '&', '<'};
        MASK_TEXT_XML10 = new char[]{'\r', '&', '<', '>', '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f'};
        MASK_ATTRIBUTE_VALUE_XML11_DQ = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '&', '<'};
        MASK_ATTRIBUTE_VALUE_XML11_SQ = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\'', '&', '<'};
        MASK_TEXT_XML11 = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '&', '<', '>', '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u2028'};
        MASK_TEXT_HTML_DQ = new char[]{'&', '\"', '<', '>', '\'', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f'};
        MASK_TEXT_HTML_SQ = new char[]{'&', '<', '>', '\'', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f'};
        MASK_ATTRIBUTE_VALUE_XML10_DQ_REPLACE = new char[MASK_ATTRIBUTE_VALUE_XML10_DQ.length][];
        MASK_ATTRIBUTE_VALUE_XML10_SQ_REPLACE = new char[MASK_ATTRIBUTE_VALUE_XML10_SQ.length][];
        MASK_TEXT_XML10_REPLACE = new char[MASK_TEXT_XML10.length][];
        MASK_ATTRIBUTE_VALUE_XML11_DQ_REPLACE = new char[MASK_ATTRIBUTE_VALUE_XML11_DQ.length][];
        MASK_ATTRIBUTE_VALUE_XML11_SQ_REPLACE = new char[MASK_ATTRIBUTE_VALUE_XML11_SQ.length][];
        MASK_TEXT_XML11_REPLACE = new char[MASK_TEXT_XML11.length][];
        MASK_TEXT_HTML_DQ_REPLACE = new char[MASK_TEXT_HTML_DQ.length][];
        MASK_TEXT_HTML_SQ_REPLACE = new char[MASK_TEXT_HTML_SQ.length][];
        INT_HEX_UC = "0123456789ABCDEF".toCharArray();
        for (n = 0; n < MASK_ATTRIBUTE_VALUE_XML10_DQ.length; ++n) {
            XMLMaskHelper.MASK_ATTRIBUTE_VALUE_XML10_DQ_REPLACE[n] = XMLMaskHelper.getXML10EntityReferenceString(MASK_ATTRIBUTE_VALUE_XML10_DQ[n]).toCharArray();
        }
        for (n = 0; n < MASK_ATTRIBUTE_VALUE_XML10_SQ.length; ++n) {
            XMLMaskHelper.MASK_ATTRIBUTE_VALUE_XML10_SQ_REPLACE[n] = XMLMaskHelper.getXML10EntityReferenceString(MASK_ATTRIBUTE_VALUE_XML10_SQ[n]).toCharArray();
        }
        for (n = 0; n < MASK_TEXT_XML10.length; ++n) {
            XMLMaskHelper.MASK_TEXT_XML10_REPLACE[n] = XMLMaskHelper.getXML10EntityReferenceString(MASK_TEXT_XML10[n]).toCharArray();
        }
        for (n = 0; n < MASK_ATTRIBUTE_VALUE_XML11_DQ.length; ++n) {
            XMLMaskHelper.MASK_ATTRIBUTE_VALUE_XML11_DQ_REPLACE[n] = XMLMaskHelper.getXML11EntityReferenceString(MASK_ATTRIBUTE_VALUE_XML11_DQ[n]).toCharArray();
        }
        for (n = 0; n < MASK_ATTRIBUTE_VALUE_XML11_SQ.length; ++n) {
            XMLMaskHelper.MASK_ATTRIBUTE_VALUE_XML11_SQ_REPLACE[n] = XMLMaskHelper.getXML11EntityReferenceString(MASK_ATTRIBUTE_VALUE_XML11_SQ[n]).toCharArray();
        }
        for (n = 0; n < MASK_TEXT_XML11.length; ++n) {
            XMLMaskHelper.MASK_TEXT_XML11_REPLACE[n] = XMLMaskHelper.getXML11EntityReferenceString(MASK_TEXT_XML11[n]).toCharArray();
        }
        for (n = 0; n < MASK_TEXT_HTML_DQ.length; ++n) {
            XMLMaskHelper.MASK_TEXT_HTML_DQ_REPLACE[n] = XMLMaskHelper.getHTMLEntityReferenceString(MASK_TEXT_HTML_DQ[n]).toCharArray();
        }
        for (n = 0; n < MASK_TEXT_HTML_SQ.length; ++n) {
            XMLMaskHelper.MASK_TEXT_HTML_SQ_REPLACE[n] = XMLMaskHelper.getHTMLEntityReferenceString(MASK_TEXT_HTML_SQ[n]).toCharArray();
        }
        INSTANCE = new XMLMaskHelper();
    }
}

