/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.read;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.pool.IMutableObjectPool;
import com.helger.base.pool.ObjectPool;
import com.helger.base.state.ESuccess;
import com.helger.base.timing.StopWatch;
import com.helger.io.resource.IReadableResource;
import com.helger.statistics.api.IMutableStatisticsHandlerCounter;
import com.helger.statistics.api.IMutableStatisticsHandlerTimer;
import com.helger.statistics.impl.StatisticsManager;
import com.helger.xml.sax.InputSourceFactory;
import com.helger.xml.serialize.read.ISAXReaderSettings;
import com.helger.xml.serialize.read.SAXReaderFactory;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

@ThreadSafe
public final class SAXReader {
    private static final IMutableStatisticsHandlerTimer STATS_SAX_TIMER = StatisticsManager.getTimerHandler((String)SAXReader.class.getName());
    private static final IMutableStatisticsHandlerCounter STATS_SAX_SUCCESS_COUNTER = StatisticsManager.getCounterHandler((String)(SAXReader.class.getName() + "$success"));
    private static final IMutableStatisticsHandlerCounter STATS_SAX_ERROR_COUNTER = StatisticsManager.getCounterHandler((String)(SAXReader.class.getName() + "$error"));
    private static final IMutableObjectPool<XMLReader> POOL = new ObjectPool(10, (Supplier)new SAXReaderFactory());
    private static final SAXReader INSTANCE = new SAXReader();

    private SAXReader() {
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull File file, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(file), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull URI uRI, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(uRI), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull URL uRL, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(uRL), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull IHasInputStream iHasInputStream, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(iHasInputStream), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull IReadableResource iReadableResource, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(iReadableResource), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull CharSequence charSequence, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(charSequence), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull String string, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(string), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull char[] cArray, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(cArray), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(cArray, n, n2), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull byte[] byArray, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(byArray), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(byArray, n, n2), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull ByteBuffer byteBuffer, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(byteBuffer), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull @WillClose InputStream inputStream, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        try {
            ESuccess eSuccess = SAXReader.readXMLSAX(InputSourceFactory.create(inputStream), iSAXReaderSettings);
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull @WillClose Reader reader, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        try {
            ESuccess eSuccess = SAXReader.readXMLSAX(InputSourceFactory.create(reader), iSAXReaderSettings);
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess readXMLSAX(@WillClose @Nonnull InputSource inputSource, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        block20: {
            ValueEnforcer.notNull((Object)inputSource, (String)"InputStream");
            ValueEnforcer.notNull((Object)iSAXReaderSettings, (String)"Settings");
            try {
                ESuccess eSuccess;
                block19: {
                    boolean bl;
                    XMLReader xMLReader;
                    SAXParserFactory sAXParserFactory = iSAXReaderSettings.getCustomSAXParserFactory();
                    if (sAXParserFactory != null) {
                        xMLReader = SAXReaderFactory.createXMLReader(sAXParserFactory);
                        bl = false;
                    } else if (iSAXReaderSettings.requiresNewXMLParser()) {
                        xMLReader = SAXReaderFactory.createXMLReader();
                        bl = false;
                    } else {
                        xMLReader = (XMLReader)POOL.borrowObject();
                        bl = true;
                    }
                    try {
                        StopWatch stopWatch = StopWatch.createdStarted();
                        iSAXReaderSettings.applyToSAXReader(xMLReader);
                        xMLReader.parse(inputSource);
                        STATS_SAX_SUCCESS_COUNTER.increment();
                        STATS_SAX_TIMER.addTime(stopWatch.stopAndGetMillis());
                        eSuccess = ESuccess.SUCCESS;
                        if (!bl) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (bl) {
                                POOL.returnObject((Object)xMLReader);
                            }
                            throw throwable;
                        }
                        catch (SAXParseException sAXParseException) {
                            bl = false;
                            if (iSAXReaderSettings.getErrorHandler() != null) {
                                try {
                                    iSAXReaderSettings.getErrorHandler().fatalError(sAXParseException);
                                    bl = true;
                                }
                                catch (SAXException sAXException) {
                                    // empty catch block
                                }
                            }
                            if (!bl) {
                                iSAXReaderSettings.exceptionCallbacks().forEach(iExceptionCallback -> iExceptionCallback.onException((Throwable)sAXParseException));
                            }
                            StreamHelper.close((AutoCloseable)inputSource.getByteStream());
                            StreamHelper.close((AutoCloseable)inputSource.getCharacterStream());
                            break block20;
                        }
                        catch (Exception exception) {
                            iSAXReaderSettings.exceptionCallbacks().forEach(iExceptionCallback -> iExceptionCallback.onException((Throwable)exception));
                            break block20;
                        }
                    }
                    POOL.returnObject((Object)xMLReader);
                }
                return eSuccess;
            }
            finally {
                StreamHelper.close((AutoCloseable)inputSource.getByteStream());
                StreamHelper.close((AutoCloseable)inputSource.getCharacterStream());
            }
        }
        STATS_SAX_ERROR_COUNTER.increment();
        return ESuccess.FAILURE;
    }
}

