/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.transform;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.stream.ByteBufferInputStream;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.URLResource;
import com.helger.io.url.URLHelper;
import com.helger.xml.transform.CachingTransformStreamSource;
import com.helger.xml.transform.StringStreamSource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

@Immutable
public final class TransformSourceFactory {
    private static final TransformSourceFactory INSTANCE = new TransformSourceFactory();

    private TransformSourceFactory() {
    }

    @Nonnull
    public static StreamSource create(@Nonnull File file) {
        return new StreamSource(file);
    }

    @Nonnull
    public static StreamSource create(@Nonnull Path path) {
        return new StreamSource(path.toFile());
    }

    @Nonnull
    public static StreamSource create(@Nonnull URI uRI) {
        return TransformSourceFactory.create(URLHelper.getAsURL((URI)uRI));
    }

    @Nonnull
    public static StreamSource create(@Nonnull URL uRL) {
        return TransformSourceFactory.create((IReadableResource)new URLResource(uRL));
    }

    @Nonnull
    public static StreamSource create(@Nonnull IHasInputStream iHasInputStream) {
        if (iHasInputStream instanceof IReadableResource) {
            IReadableResource iReadableResource = (IReadableResource)iHasInputStream;
            return TransformSourceFactory.create(iReadableResource);
        }
        return TransformSourceFactory.create(iHasInputStream.getInputStream());
    }

    @Nonnull
    public static StreamSource create(@Nonnull IReadableResource iReadableResource) {
        return new CachingTransformStreamSource(iReadableResource);
    }

    @Nonnull
    public static StringStreamSource create(@Nonnull CharSequence charSequence) {
        return new StringStreamSource(charSequence);
    }

    @Nonnull
    public static StringStreamSource create(@Nonnull String string) {
        return new StringStreamSource(string);
    }

    @Nonnull
    public static StringStreamSource create(@Nonnull char[] cArray) {
        return new StringStreamSource(cArray);
    }

    @Nonnull
    public static StringStreamSource create(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return new StringStreamSource(cArray, n, n2);
    }

    @Nonnull
    public static StreamSource create(@Nonnull byte[] byArray) {
        return TransformSourceFactory.create((InputStream)new NonBlockingByteArrayInputStream(byArray));
    }

    @Nonnull
    public static StreamSource create(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return TransformSourceFactory.create((InputStream)new NonBlockingByteArrayInputStream(byArray, n, n2));
    }

    @Nonnull
    public static StreamSource create(@Nonnull ByteBuffer byteBuffer) {
        return TransformSourceFactory.create((InputStream)new ByteBufferInputStream(byteBuffer));
    }

    @Nonnull
    public static StreamSource create(@Nullable InputStream inputStream) {
        return new StreamSource(inputStream);
    }

    @Nonnull
    public static StreamSource create(@Nullable Reader reader) {
        return new StreamSource(reader);
    }

    @Nonnull
    public static DOMSource create(@Nullable Node node) {
        return new DOMSource(node);
    }
}

