/*
 * Decompiled with CFR 0.152.
 */
package com.helger.url.param;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.codec.IEncoder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class URLParameter {
    private final String m_sName;
    private final String m_sValue;
    private int m_nHashCode = 0;

    public URLParameter(@NonNull @Nonempty String string) {
        this(string, "");
    }

    public URLParameter(@NonNull @Nonempty String string, @NonNull String string2) {
        this.m_sName = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        this.m_sValue = (String)ValueEnforcer.notNull((Object)string2, (String)"Value");
    }

    public @NonNull @Nonempty String getName() {
        return this.m_sName;
    }

    public boolean hasName(@Nullable String string) {
        return this.m_sName.equals(string);
    }

    public @NonNull String getValue() {
        return this.m_sValue;
    }

    public boolean hasValue() {
        return !this.m_sValue.isEmpty();
    }

    public boolean hasValue(@Nullable String string) {
        return this.m_sValue.equals(string);
    }

    public void appendTo(@NonNull StringBuilder stringBuilder, @Nullable IEncoder<String, String> iEncoder) {
        if (iEncoder != null) {
            stringBuilder.append((String)iEncoder.getEncoded((Object)this.m_sName));
        } else {
            stringBuilder.append(this.m_sName);
        }
        if (this.hasValue()) {
            stringBuilder.append('=');
            if (iEncoder != null) {
                stringBuilder.append((String)iEncoder.getEncoded((Object)this.m_sValue));
            } else {
                stringBuilder.append(this.m_sValue);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        URLParameter uRLParameter = (URLParameter)object;
        return this.m_sName.equals(uRLParameter.m_sName) && this.m_sValue.equals(uRLParameter.m_sValue);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator((Object)this).append((Object)this.m_sName).append((Object)this.m_sValue).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator(null).append("Name", (Object)this.m_sName).append("Value", (Object)this.m_sValue).getToString();
    }
}

