/*
 * Decompiled with CFR 0.152.
 */
package com.helger.url.codec;

import com.helger.base.codec.IEncoder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.url.codec.URLCoder;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class URLParameterEncoder
implements IEncoder<String, String> {
    private final Charset m_aCharset;

    public URLParameterEncoder(@NonNull Charset charset) {
        this.m_aCharset = (Charset)ValueEnforcer.notNull((Object)charset, (String)"Charset");
    }

    public final @NonNull Charset getCharset() {
        return this.m_aCharset;
    }

    public @Nullable String getEncoded(@Nullable String string) {
        return string == null ? null : URLCoder.urlEncode(string, this.m_aCharset);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Charset", (Object)this.m_aCharset).getToString();
    }
}

