/*
 * Decompiled with CFR 0.152.
 */
package com.helger.url;

import com.helger.base.url.URLHelper;
import com.helger.collection.commons.ICommonsList;
import com.helger.url.SimpleURLHelper;
import com.helger.url.data.IURLData;
import com.helger.url.param.URLParameter;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface ISimpleURL
extends IURLData {
    public @NonNull ISimpleURL getWithPath(@NonNull String var1);

    public @NonNull ISimpleURL getWithParams(@Nullable ICommonsList<URLParameter> var1);

    public @NonNull ISimpleURL getWithAnchor(@Nullable String var1);

    public @NonNull ISimpleURL getWithCharset(@Nullable Charset var1);

    default public @NonNull String getAsString() {
        return SimpleURLHelper.getURLString(this);
    }

    @Deprecated(forRemoval=true, since="12.0.0-rc2")
    default public @NonNull String getAsStringWithEncodedParameters() {
        return this.getAsString();
    }

    @Deprecated(forRemoval=true, since="12.0.0-rc2")
    default public @NonNull String getAsStringWithEncodedParameters(@Nullable Charset charset) {
        return this.getWithCharset(charset).getAsString();
    }

    @Deprecated(forRemoval=true, since="12.0.0-rc2")
    default public @NonNull String getAsStringWithoutEncodedParameters() {
        return this.getAsString();
    }

    default public @Nullable URL getAsURL() {
        return URLHelper.getAsURL((String)this.getAsString());
    }

    default public @Nullable URI getAsURI() {
        return URLHelper.getAsURI((String)this.getAsString());
    }
}

