/*
 * Decompiled with CFR 0.152.
 */
package com.helger.url;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.ICommonsList;
import com.helger.url.ISimpleURL;
import com.helger.url.SimpleURLHelper;
import com.helger.url.data.IURLData;
import com.helger.url.data.URLData;
import com.helger.url.param.URLParameter;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class ReadOnlyURL
implements ISimpleURL {
    private final URLData m_aData;

    protected ReadOnlyURL(@NonNull URLData uRLData) {
        this.m_aData = uRLData;
    }

    @Override
    public final @NonNull String getPath() {
        return this.m_aData.getPath();
    }

    @Override
    @ReturnsMutableCopy
    public final @NonNull ICommonsList<URLParameter> getAllParams() {
        return (ICommonsList)this.m_aData.params().getClone();
    }

    @Override
    public @Nullable String getFirstParamValue(@Nullable String string) {
        return this.m_aData.getFirstParamValue(string);
    }

    @Override
    public final @Nullable String getAnchor() {
        return this.m_aData.getAnchor();
    }

    @Override
    public final @NonNull Charset getCharset() {
        return this.m_aData.getCharset();
    }

    @Override
    public final @NonNull ReadOnlyURL getWithPath(@NonNull String string) {
        if (this.m_aData.getPath().equals(string)) {
            return this;
        }
        return new ReadOnlyURL(this.m_aData.getClone().setPath(string));
    }

    @Override
    public final @NonNull ReadOnlyURL getWithParams(@Nullable ICommonsList<URLParameter> iCommonsList) {
        if (EqualsHelper.equals(this.m_aData.params(), iCommonsList)) {
            return this;
        }
        return new ReadOnlyURL((URLData)this.m_aData.getClone().setParams((ICommonsList)iCommonsList));
    }

    @Override
    public final @NonNull ReadOnlyURL getWithAnchor(@Nullable String string) {
        if (this.m_aData.hasAnchor(string)) {
            return this;
        }
        return new ReadOnlyURL(this.m_aData.getClone().setAnchor(string));
    }

    @Override
    public final @NonNull ReadOnlyURL getWithCharset(@Nullable Charset charset) {
        if (EqualsHelper.equals((Object)this.m_aData.getCharset(), (Object)charset)) {
            return this;
        }
        return new ReadOnlyURL(this.m_aData.getClone().setCharset(charset));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ReadOnlyURL readOnlyURL = (ReadOnlyURL)object;
        return this.m_aData.equals(readOnlyURL.m_aData);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aData).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Data", (Object)this.m_aData).getToString();
    }

    public static @NonNull ReadOnlyURL of(@NonNull IURLData iURLData) {
        return new ReadOnlyURL(new URLData(iURLData));
    }

    public static @NonNull ReadOnlyURL of(@NonNull URL uRL) {
        return ReadOnlyURL.of(uRL, URLData.DEFAULT_CHARSET);
    }

    public static @NonNull ReadOnlyURL of(@NonNull URL uRL, @Nullable Charset charset) {
        return ReadOnlyURL.of(uRL.toExternalForm(), charset);
    }

    public static @NonNull ReadOnlyURL of(@NonNull URI uRI) {
        return ReadOnlyURL.of(uRI, URLData.DEFAULT_CHARSET);
    }

    public static @NonNull ReadOnlyURL of(@NonNull URI uRI, @Nullable Charset charset) {
        return ReadOnlyURL.of(uRI.toString(), charset);
    }

    public static @NonNull ReadOnlyURL of(@NonNull String string) {
        return ReadOnlyURL.of(string, URLData.DEFAULT_CHARSET);
    }

    public static @NonNull ReadOnlyURL of(@NonNull String string, @Nullable Charset charset) {
        return new ReadOnlyURL(SimpleURLHelper.getAsURLData(string, charset));
    }
}

