/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree.withid.folder;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.aggregate.IAggregator;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.tree.withid.BasicTreeItemWithID;
import com.helger.tree.withid.folder.IFolderTreeItem;
import com.helger.tree.withid.folder.IFolderTreeItemFactory;
import java.util.Collection;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class BasicFolderTreeItem<KEYTYPE, DATATYPE, COLLTYPE extends Collection<DATATYPE>, ITEMTYPE extends BasicFolderTreeItem<KEYTYPE, DATATYPE, COLLTYPE, ITEMTYPE>>
extends BasicTreeItemWithID<KEYTYPE, COLLTYPE, ITEMTYPE>
implements IFolderTreeItem<KEYTYPE, DATATYPE, COLLTYPE, ITEMTYPE> {
    private final IAggregator<KEYTYPE, KEYTYPE> m_aKeyCombinator;

    public BasicFolderTreeItem(@NonNull IFolderTreeItemFactory<KEYTYPE, DATATYPE, COLLTYPE, ITEMTYPE> iFolderTreeItemFactory) {
        super(iFolderTreeItemFactory);
        this.m_aKeyCombinator = iFolderTreeItemFactory.getKeyCombinator();
    }

    public BasicFolderTreeItem(@NonNull IFolderTreeItemFactory<KEYTYPE, DATATYPE, COLLTYPE, ITEMTYPE> iFolderTreeItemFactory, @Nullable KEYTYPE KEYTYPE) {
        super(iFolderTreeItemFactory, KEYTYPE);
        this.m_aKeyCombinator = iFolderTreeItemFactory.getKeyCombinator();
    }

    public BasicFolderTreeItem(@NonNull ITEMTYPE ITEMTYPE, @NonNull KEYTYPE KEYTYPE) {
        super(ITEMTYPE, KEYTYPE);
        this.m_aKeyCombinator = ((BasicFolderTreeItem)ITEMTYPE).m_aKeyCombinator;
    }

    @Override
    public final @NonNull KEYTYPE getGlobalUniqueDataID() {
        if (this.m_aKeyCombinator == null) {
            return this.getID();
        }
        BasicFolderTreeItem basicFolderTreeItem = (BasicFolderTreeItem)this.getParent();
        if (basicFolderTreeItem == null) {
            return this.getID();
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList(new Object[]{basicFolderTreeItem.getGlobalUniqueDataID(), this.getID()});
        return (KEYTYPE)this.m_aKeyCombinator.apply((Object)commonsArrayList);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        BasicFolderTreeItem basicFolderTreeItem = (BasicFolderTreeItem)object;
        return EqualsHelper.equals(this.m_aKeyCombinator, basicFolderTreeItem.m_aKeyCombinator);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_aKeyCombinator).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("keyCombinator", this.m_aKeyCombinator).getToString();
    }
}

