/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree.util;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasID;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.hierarchy.IChildrenProvider;
import com.helger.collection.hierarchy.IHasParent;
import com.helger.collection.hierarchy.IParentProvider;
import com.helger.tree.withid.DefaultTreeItemWithID;
import com.helger.tree.withid.DefaultTreeWithID;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class TreeWithIDBuilder {
    private static final TreeWithIDBuilder INSTANCE = new TreeWithIDBuilder();

    private TreeWithIDBuilder() {
    }

    private static <KEYTYPE, DATATYPE extends IHasID<KEYTYPE>> @NonNull DefaultTreeWithID<KEYTYPE, DATATYPE> _buildTree(@NonNull List<DATATYPE> list, @NonNull IParentProvider<DATATYPE> iParentProvider) {
        DefaultTreeWithID defaultTreeWithID = new DefaultTreeWithID();
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        int n = 0;
        while (!list.isEmpty()) {
            Object object;
            IHasID iHasID = (IHasID)list.remove(0);
            IHasID iHasID2 = (IHasID)iParentProvider.getParent((Object)iHasID);
            Object object2 = iHasID.getID();
            if (iHasID2 == null) {
                object = (DefaultTreeItemWithID)((DefaultTreeItemWithID)defaultTreeWithID.getRootItem()).createChildItem(object2, iHasID);
                commonsHashMap.put(object2, object);
                n = 0;
                continue;
            }
            object = iHasID2.getID();
            if (commonsHashMap.containsKey(object)) {
                DefaultTreeItemWithID defaultTreeItemWithID = (DefaultTreeItemWithID)commonsHashMap.get(object);
                DefaultTreeItemWithID defaultTreeItemWithID2 = (DefaultTreeItemWithID)defaultTreeItemWithID.createChildItem(object2, iHasID);
                commonsHashMap.put(object2, (Object)defaultTreeItemWithID2);
                n = 0;
                continue;
            }
            list.add(iHasID);
            if (++n != list.size()) continue;
            throw new IllegalStateException("The hierarchy is illegal. It contains elements that fit nowhere in the tree: " + String.valueOf(list));
        }
        return defaultTreeWithID;
    }

    public static <KEYTYPE, DATATYPE extends IHasID<KEYTYPE>> @NonNull DefaultTreeWithID<KEYTYPE, DATATYPE> buildTree(@NonNull Collection<? extends DATATYPE> collection, @NonNull IParentProvider<DATATYPE> iParentProvider) {
        ValueEnforcer.notNull(collection, (String)"All");
        ValueEnforcer.notNull(iParentProvider, (String)"ParentResolver");
        return TreeWithIDBuilder._buildTree(new CommonsArrayList(collection), iParentProvider);
    }

    public static <KEYTYPE, DATATYPE extends IHasID<KEYTYPE>> @NonNull DefaultTreeWithID<KEYTYPE, DATATYPE> buildTree(@NonNull DATATYPE[] DATATYPEArray, @NonNull IParentProvider<DATATYPE> iParentProvider) {
        ValueEnforcer.notNull(DATATYPEArray, (String)"All");
        ValueEnforcer.notNull(iParentProvider, (String)"ParentResolver");
        return TreeWithIDBuilder._buildTree(new CommonsArrayList((Object[])DATATYPEArray), iParentProvider);
    }

    public static <KEYTYPE, DATATYPE extends IHasParent<DATATYPE> & IHasID<KEYTYPE>> @NonNull DefaultTreeWithID<KEYTYPE, DATATYPE> buildTree(@NonNull Collection<? extends DATATYPE> collection) {
        ValueEnforcer.notNull(collection, (String)"All");
        return TreeWithIDBuilder.buildTree(collection, IParentProvider.parentProviderHasParent());
    }

    private static <KEYTYPE, DATATYPE extends IHasID<KEYTYPE>> void _buildTreeRecursive(@Nullable DefaultTreeItemWithID<KEYTYPE, DATATYPE> defaultTreeItemWithID, @NonNull IChildrenProvider<DATATYPE> iChildrenProvider) {
        IHasID iHasID;
        if (defaultTreeItemWithID != null && iChildrenProvider.hasChildren((Object)(iHasID = (IHasID)defaultTreeItemWithID.getData()))) {
            for (IHasID iHasID2 : iChildrenProvider.getAllChildren((Object)iHasID)) {
                DefaultTreeItemWithID defaultTreeItemWithID2 = (DefaultTreeItemWithID)defaultTreeItemWithID.createChildItem(iHasID2.getID(), iHasID2);
                TreeWithIDBuilder._buildTreeRecursive(defaultTreeItemWithID2, iChildrenProvider);
            }
        }
    }

    public static <KEYTYPE, DATATYPE extends IHasID<KEYTYPE>> @NonNull DefaultTreeWithID<KEYTYPE, DATATYPE> buildTree(@NonNull IChildrenProvider<DATATYPE> iChildrenProvider) {
        ValueEnforcer.notNull(iChildrenProvider, (String)"ChildrenResolver");
        DefaultTreeWithID defaultTreeWithID = new DefaultTreeWithID();
        if (iChildrenProvider.hasChildren(null)) {
            for (IHasID iHasID : iChildrenProvider.getAllChildren(null)) {
                DefaultTreeItemWithID defaultTreeItemWithID = (DefaultTreeItemWithID)((DefaultTreeItemWithID)defaultTreeWithID.getRootItem()).createChildItem(iHasID.getID(), iHasID);
                TreeWithIDBuilder._buildTreeRecursive(defaultTreeItemWithID, iChildrenProvider);
            }
        }
        return defaultTreeWithID;
    }
}

