/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree.util;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.hierarchy.ChildrenProviderHasChildren;
import com.helger.collection.hierarchy.IChildrenProvider;
import com.helger.collection.hierarchy.visit.ChildrenProviderHierarchyVisitor;
import com.helger.collection.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.collection.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.collection.hierarchy.visit.IHierarchyVisitorCallback;
import com.helger.tree.IBasicTree;
import com.helger.tree.IBasicTreeItem;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;

@Immutable
public final class TreeVisitor {
    private static final TreeVisitor INSTANCE = new TreeVisitor();

    private TreeVisitor() {
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void visitTree(@NonNull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @NonNull IHierarchyVisitorCallback<? super ITEMTYPE> iHierarchyVisitorCallback) {
        TreeVisitor.visitTree(iBasicTree, new ChildrenProviderHasChildren(), iHierarchyVisitorCallback);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void visitTree(@NonNull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @NonNull IChildrenProvider<ITEMTYPE> iChildrenProvider, @NonNull IHierarchyVisitorCallback<? super ITEMTYPE> iHierarchyVisitorCallback) {
        ValueEnforcer.notNull(iBasicTree, (String)"Tree");
        TreeVisitor.visitTreeItem(iBasicTree.getRootItem(), iChildrenProvider, iHierarchyVisitorCallback);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void visitTreeData(@NonNull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @NonNull IHierarchyVisitorCallback<? super DATATYPE> iHierarchyVisitorCallback) {
        TreeVisitor.visitTreeData(iBasicTree, new ChildrenProviderHasChildren(), iHierarchyVisitorCallback);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void visitTreeData(@NonNull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @NonNull IChildrenProvider<ITEMTYPE> iChildrenProvider, @NonNull IHierarchyVisitorCallback<? super DATATYPE> iHierarchyVisitorCallback) {
        ValueEnforcer.notNull(iBasicTree, (String)"Tree");
        TreeVisitor.visitTreeItemData(iBasicTree.getRootItem(), iChildrenProvider, iHierarchyVisitorCallback);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void visitTreeItem(@NonNull ITEMTYPE ITEMTYPE, @NonNull IHierarchyVisitorCallback<? super ITEMTYPE> iHierarchyVisitorCallback) {
        ValueEnforcer.notNull(ITEMTYPE, (String)"TreeItem");
        ChildrenProviderHierarchyVisitor.visitFrom(ITEMTYPE, iHierarchyVisitorCallback, (boolean)false);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void visitTreeItem(@NonNull ITEMTYPE ITEMTYPE, @NonNull IChildrenProvider<ITEMTYPE> iChildrenProvider, @NonNull IHierarchyVisitorCallback<? super ITEMTYPE> iHierarchyVisitorCallback) {
        ValueEnforcer.notNull(ITEMTYPE, (String)"TreeItem");
        ChildrenProviderHierarchyVisitor.visitFrom(ITEMTYPE, iChildrenProvider, iHierarchyVisitorCallback, (boolean)false);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void visitTreeItemData(@NonNull ITEMTYPE ITEMTYPE, @NonNull IHierarchyVisitorCallback<? super DATATYPE> iHierarchyVisitorCallback) {
        TreeVisitor.visitTreeItemData(ITEMTYPE, new ChildrenProviderHasChildren(), iHierarchyVisitorCallback);
    }

    public static <DATATYPE, ITEMTYPE extends IBasicTreeItem<DATATYPE, ITEMTYPE>> void visitTreeItemData(@NonNull ITEMTYPE ITEMTYPE, @NonNull IChildrenProvider<ITEMTYPE> iChildrenProvider, @NonNull IHierarchyVisitorCallback<? super DATATYPE> iHierarchyVisitorCallback) {
        ValueEnforcer.notNull(iHierarchyVisitorCallback, (String)"DataCallback");
        TreeVisitor.visitTreeItem(ITEMTYPE, iChildrenProvider, new HierarchyVisitorCallbackWithConversion<IBasicTreeItem, Object>(iHierarchyVisitorCallback, IBasicTreeItem::getData));
    }

    public static class HierarchyVisitorCallbackWithConversion<ITEMTYPE, DATATYPE>
    extends DefaultHierarchyVisitorCallback<ITEMTYPE> {
        private final IHierarchyVisitorCallback<? super DATATYPE> m_aDataCallback;
        private final Function<? super ITEMTYPE, ? extends DATATYPE> m_aConverter;

        public HierarchyVisitorCallbackWithConversion(@NonNull IHierarchyVisitorCallback<? super DATATYPE> iHierarchyVisitorCallback, @NonNull Function<? super ITEMTYPE, ? extends DATATYPE> function) {
            this.m_aDataCallback = (IHierarchyVisitorCallback)ValueEnforcer.notNull(iHierarchyVisitorCallback, (String)"DataCallback");
            this.m_aConverter = (Function)ValueEnforcer.notNull(function, (String)"Converter");
        }

        public void begin() {
            super.begin();
            this.m_aDataCallback.begin();
        }

        public void onLevelDown() {
            super.onLevelDown();
            this.m_aDataCallback.onLevelDown();
        }

        public void onLevelUp() {
            this.m_aDataCallback.onLevelUp();
            super.onLevelUp();
        }

        public @NonNull EHierarchyVisitorReturn onItemBeforeChildren(@NonNull ITEMTYPE ITEMTYPE) {
            DATATYPE DATATYPE = this.m_aConverter.apply(ITEMTYPE);
            return this.m_aDataCallback.onItemBeforeChildren(DATATYPE);
        }

        public @NonNull EHierarchyVisitorReturn onItemAfterChildren(@NonNull ITEMTYPE ITEMTYPE) {
            DATATYPE DATATYPE = this.m_aConverter.apply(ITEMTYPE);
            return this.m_aDataCallback.onItemAfterChildren(DATATYPE);
        }

        public void end() {
            this.m_aDataCallback.end();
            super.end();
        }
    }
}

