/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree.xml;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.id.IHasID;
import com.helger.collection.hierarchy.ChildrenProviderHasChildrenSorting;
import com.helger.collection.hierarchy.IChildrenProvider;
import com.helger.collection.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.collection.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.collection.hierarchy.visit.IHierarchyVisitorCallback;
import com.helger.collection.stack.NonBlockingStack;
import com.helger.tree.IBasicTree;
import com.helger.tree.ITreeItem;
import com.helger.tree.util.TreeVisitor;
import com.helger.tree.withid.BasicTreeWithID;
import com.helger.tree.withid.DefaultTreeWithID;
import com.helger.tree.withid.ITreeItemWithID;
import com.helger.tree.withid.unique.DefaultTreeWithGlobalUniqueID;
import com.helger.tree.xml.IConverterMicroNodeToTreeItem;
import com.helger.tree.xml.IConverterTreeItemToMicroNode;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.util.ChildrenProviderElementWithName;
import com.helger.xml.microdom.util.MicroVisitor;
import java.util.Comparator;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class TreeXMLConverter {
    public static final String ELEMENT_ROOT = "root";
    public static final String ELEMENT_ITEM = "item";
    public static final String ATTR_ID = "id";
    public static final String ELEMENT_DATA = "data";
    private static final TreeXMLConverter INSTANCE = new TreeXMLConverter();

    private TreeXMLConverter() {
    }

    public static <DATATYPE, ITEMTYPE extends ITreeItemWithID<String, DATATYPE, ITEMTYPE>> @NonNull IMicroElement getTreeWithStringIDAsXML(@NonNull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @NonNull IConverterTreeItemToMicroNode<? super DATATYPE> iConverterTreeItemToMicroNode) {
        return TreeXMLConverter.getTreeWithIDAsXML(iBasicTree, IHasID.getComparatorID(), string -> string, iConverterTreeItemToMicroNode);
    }

    public static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void fillTreeWithIDAsXML(@NonNull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @NonNull Comparator<? super ITEMTYPE> comparator, final @NonNull Function<? super KEYTYPE, ? extends String> function, final @NonNull IConverterTreeItemToMicroNode<? super DATATYPE> iConverterTreeItemToMicroNode, @NonNull IMicroElement iMicroElement) {
        final String string = iConverterTreeItemToMicroNode.getNamespaceURI();
        final NonBlockingStack nonBlockingStack = new NonBlockingStack();
        nonBlockingStack.push((Object)iMicroElement);
        TreeVisitor.visitTree(iBasicTree, new ChildrenProviderHasChildrenSorting(comparator), new DefaultHierarchyVisitorCallback<ITEMTYPE>(){

            public @NonNull EHierarchyVisitorReturn onItemBeforeChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    IMicroElement iMicroElement = ((IMicroElement)nonBlockingStack.peek()).addElementNS(string, TreeXMLConverter.ELEMENT_ITEM);
                    iMicroElement.setAttribute(TreeXMLConverter.ATTR_ID, (String)function.apply(ITEMTYPE.getID()));
                    IMicroElement iMicroElement2 = iMicroElement.addElementNS(string, TreeXMLConverter.ELEMENT_DATA);
                    iConverterTreeItemToMicroNode.appendDataValue(iMicroElement2, ITEMTYPE.getData());
                    nonBlockingStack.push((Object)iMicroElement);
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }

            public @NonNull EHierarchyVisitorReturn onItemAfterChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    nonBlockingStack.pop();
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }
        });
    }

    public static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> @NonNull IMicroElement getTreeWithIDAsXML(@NonNull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @NonNull Comparator<? super ITEMTYPE> comparator, @NonNull Function<? super KEYTYPE, ? extends String> function, @NonNull IConverterTreeItemToMicroNode<? super DATATYPE> iConverterTreeItemToMicroNode) {
        String string = iConverterTreeItemToMicroNode.getNamespaceURI();
        MicroElement microElement = new MicroElement(string, ELEMENT_ROOT);
        TreeXMLConverter.fillTreeWithIDAsXML(iBasicTree, comparator, function, iConverterTreeItemToMicroNode, (IMicroElement)microElement);
        return microElement;
    }

    public static <DATATYPE, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>> void fillTreeAsXML(@NonNull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @NonNull Comparator<? super ITEMTYPE> comparator, final @NonNull IConverterTreeItemToMicroNode<? super DATATYPE> iConverterTreeItemToMicroNode, @NonNull IMicroElement iMicroElement) {
        final String string = iConverterTreeItemToMicroNode.getNamespaceURI();
        final NonBlockingStack nonBlockingStack = new NonBlockingStack();
        nonBlockingStack.push((Object)iMicroElement);
        TreeVisitor.visitTree(iBasicTree, new ChildrenProviderHasChildrenSorting(comparator), new DefaultHierarchyVisitorCallback<ITEMTYPE>(){

            public @NonNull EHierarchyVisitorReturn onItemBeforeChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    IMicroElement iMicroElement = ((IMicroElement)nonBlockingStack.peek()).addElementNS(string, TreeXMLConverter.ELEMENT_ITEM);
                    IMicroElement iMicroElement2 = iMicroElement.addElementNS(string, TreeXMLConverter.ELEMENT_DATA);
                    iConverterTreeItemToMicroNode.appendDataValue(iMicroElement2, ITEMTYPE.getData());
                    nonBlockingStack.push((Object)iMicroElement);
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }

            public @NonNull EHierarchyVisitorReturn onItemAfterChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    nonBlockingStack.pop();
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }
        });
    }

    public static <DATATYPE, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>> @NonNull IMicroElement getTreeAsXML(@NonNull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @NonNull Comparator<? super ITEMTYPE> comparator, @NonNull IConverterTreeItemToMicroNode<? super DATATYPE> iConverterTreeItemToMicroNode) {
        String string = iConverterTreeItemToMicroNode.getNamespaceURI();
        MicroElement microElement = new MicroElement(string, ELEMENT_ROOT);
        TreeXMLConverter.fillTreeAsXML(iBasicTree, comparator, iConverterTreeItemToMicroNode, (IMicroElement)microElement);
        return microElement;
    }

    public static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void fillXMLAsTreeWithID(@NonNull IMicroElement iMicroElement, final @NonNull Function<? super String, ? extends KEYTYPE> function, final @NonNull IConverterMicroNodeToTreeItem<? extends DATATYPE> iConverterMicroNodeToTreeItem, @NonNull BasicTreeWithID<KEYTYPE, DATATYPE, ITEMTYPE> basicTreeWithID) {
        final String string = iConverterMicroNodeToTreeItem.getNamespaceURI();
        final NonBlockingStack nonBlockingStack = new NonBlockingStack();
        nonBlockingStack.push((Object)basicTreeWithID.getRootItem());
        MicroVisitor.visit((IMicroNode)iMicroElement, (IChildrenProvider)new ChildrenProviderElementWithName(string, ELEMENT_ITEM), (IHierarchyVisitorCallback)new DefaultHierarchyVisitorCallback<IMicroElement>(){

            public @NonNull EHierarchyVisitorReturn onItemBeforeChildren(@Nullable IMicroElement iMicroElement) {
                if (iMicroElement != null) {
                    Object r = function.apply(iMicroElement.getAttributeValue(TreeXMLConverter.ATTR_ID));
                    IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string, TreeXMLConverter.ELEMENT_DATA);
                    Object DATATYPE = iConverterMicroNodeToTreeItem.getAsDataValue(iMicroElement2);
                    Object ITEMTYPE = ((ITreeItemWithID)nonBlockingStack.peek()).createChildItem(r, DATATYPE);
                    nonBlockingStack.push(ITEMTYPE);
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }

            public @NonNull EHierarchyVisitorReturn onItemAfterChildren(@Nullable IMicroElement iMicroElement) {
                if (iMicroElement != null) {
                    nonBlockingStack.pop();
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }
        });
    }

    public static <DATATYPE> @NonNull DefaultTreeWithGlobalUniqueID<String, DATATYPE> getXMLAsTreeWithUniqueStringID(@NonNull IMicroElement iMicroElement, @NonNull IConverterMicroNodeToTreeItem<? extends DATATYPE> iConverterMicroNodeToTreeItem) {
        return TreeXMLConverter.getXMLAsTreeWithUniqueID(iMicroElement, string -> string, iConverterMicroNodeToTreeItem);
    }

    public static <KEYTYPE, DATATYPE> @NonNull DefaultTreeWithGlobalUniqueID<KEYTYPE, DATATYPE> getXMLAsTreeWithUniqueID(@NonNull IMicroElement iMicroElement, @NonNull Function<? super String, ? extends KEYTYPE> function, @NonNull IConverterMicroNodeToTreeItem<? extends DATATYPE> iConverterMicroNodeToTreeItem) {
        DefaultTreeWithGlobalUniqueID defaultTreeWithGlobalUniqueID = new DefaultTreeWithGlobalUniqueID();
        TreeXMLConverter.fillXMLAsTreeWithID(iMicroElement, function, iConverterMicroNodeToTreeItem, defaultTreeWithGlobalUniqueID);
        return defaultTreeWithGlobalUniqueID;
    }

    public static <KEYTYPE, DATATYPE> @NonNull DefaultTreeWithID<KEYTYPE, DATATYPE> getXMLAsTreeWithID(@NonNull IMicroElement iMicroElement, @NonNull Function<? super String, ? extends KEYTYPE> function, @NonNull IConverterMicroNodeToTreeItem<? extends DATATYPE> iConverterMicroNodeToTreeItem) {
        DefaultTreeWithID defaultTreeWithID = new DefaultTreeWithID();
        TreeXMLConverter.fillXMLAsTreeWithID(iMicroElement, function, iConverterMicroNodeToTreeItem, defaultTreeWithID);
        return defaultTreeWithID;
    }
}

