/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree.withid.unique;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.tree.IBasicTreeItem;
import com.helger.tree.withid.ITreeItemWithID;
import com.helger.tree.withid.unique.ITreeItemWithUniqueIDFactory;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public abstract class AbstractTreeItemWithUniqueIDFactory<KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>>
implements ITreeItemWithUniqueIDFactory<KEYTYPE, DATATYPE, ITEMTYPE> {
    private final ICommonsMap<KEYTYPE, ITEMTYPE> m_aItemStore;

    protected AbstractTreeItemWithUniqueIDFactory() {
        this((ICommonsMap<KEYTYPE, ITEMTYPE>)new CommonsHashMap());
    }

    protected AbstractTreeItemWithUniqueIDFactory(@NonNull ICommonsMap<KEYTYPE, ITEMTYPE> iCommonsMap) {
        this.m_aItemStore = (ICommonsMap)ValueEnforcer.notNull(iCommonsMap, (String)"ItemStore");
    }

    protected final @NonNull ITEMTYPE addToItemStore(@NonNull KEYTYPE KEYTYPE, @NonNull ITEMTYPE ITEMTYPE) {
        if (this.m_aItemStore.containsKey(KEYTYPE)) {
            throw new IllegalArgumentException("An item with ID '" + String.valueOf(KEYTYPE) + "' is already contained!");
        }
        this.m_aItemStore.put(KEYTYPE, ITEMTYPE);
        return ITEMTYPE;
    }

    protected abstract @NonNull ITEMTYPE internalCreate(@NonNull ITEMTYPE var1, @NonNull KEYTYPE var2);

    @OverrideOnDemand
    protected @NonNull KEYTYPE internalGetItemID(@NonNull ITEMTYPE ITEMTYPE) {
        return ITEMTYPE.getID();
    }

    @Override
    public final @NonNull ITEMTYPE create(@NonNull ITEMTYPE ITEMTYPE, @NonNull KEYTYPE KEYTYPE) {
        ValueEnforcer.notNull(ITEMTYPE, (String)"Parent");
        ITEMTYPE ITEMTYPE2 = this.internalCreate(ITEMTYPE, KEYTYPE);
        return this.addToItemStore(this.internalGetItemID(ITEMTYPE2), ITEMTYPE2);
    }

    @Override
    public final void onRemoveItem(@NonNull ITEMTYPE ITEMTYPE) {
        this.m_aItemStore.remove(this.internalGetItemID(ITEMTYPE));
    }

    @Override
    public final void onAddItem(@NonNull ITEMTYPE ITEMTYPE) {
        this.addToItemStore(this.internalGetItemID(ITEMTYPE), ITEMTYPE);
    }

    @Override
    public final boolean containsItemWithDataID(@Nullable KEYTYPE KEYTYPE) {
        return this.m_aItemStore.containsKey(KEYTYPE);
    }

    @Override
    public final @Nullable ITEMTYPE getItemOfDataID(@Nullable KEYTYPE KEYTYPE) {
        return (ITEMTYPE)((ITreeItemWithID)this.m_aItemStore.get(KEYTYPE));
    }

    @Override
    @Nonnegative
    public final int getItemCount() {
        return this.m_aItemStore.size();
    }

    @Override
    @ReturnsMutableCopy
    public final @NonNull ICommonsList<ITEMTYPE> getAllItems() {
        return this.m_aItemStore.copyOfValues();
    }

    @Override
    @ReturnsMutableCopy
    public final @NonNull ICommonsList<DATATYPE> getAllItemDatas() {
        return this.m_aItemStore.copyOfValuesMapped(IBasicTreeItem::getData);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractTreeItemWithUniqueIDFactory abstractTreeItemWithUniqueIDFactory = (AbstractTreeItemWithUniqueIDFactory)object;
        return this.m_aItemStore.equals(abstractTreeItemWithUniqueIDFactory.m_aItemStore);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aItemStore).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("itemStoreKeys", (Object)this.m_aItemStore.keySet()).getToString();
    }
}

