/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tree.sort;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasID;
import com.helger.collection.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.collection.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.tree.IBasicTree;
import com.helger.tree.IBasicTreeItem;
import com.helger.tree.util.TreeVisitor;
import com.helger.tree.withid.ITreeItemWithID;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;

@Immutable
public final class TreeWithIDSorter {
    private static final TreeWithIDSorter INSTANCE = new TreeWithIDSorter();

    private TreeWithIDSorter() {
    }

    private static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void _sort(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, final @Nonnull Comparator<? super ITEMTYPE> comparator) {
        ValueEnforcer.notNull(iBasicTree, (String)"Tree");
        ValueEnforcer.notNull(comparator, (String)"Comparator");
        ((ITreeItemWithID)iBasicTree.getRootItem()).reorderChildrenByItems(comparator);
        TreeVisitor.visitTree(iBasicTree, new DefaultHierarchyVisitorCallback<ITEMTYPE>(){

            public EHierarchyVisitorReturn onItemBeforeChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    ITEMTYPE.reorderChildrenByItems(comparator);
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }
        });
    }

    public static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void sortByID(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull Comparator<? super KEYTYPE> comparator) {
        TreeWithIDSorter._sort(iBasicTree, Comparator.comparing(IHasID::getID, comparator));
    }

    public static <KEYTYPE extends Comparable<? super KEYTYPE>, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void sortByID(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree) {
        TreeWithIDSorter._sort(iBasicTree, IHasID.getComparatorID());
    }

    public static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void sortByValue(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull Comparator<? super DATATYPE> comparator) {
        TreeWithIDSorter._sort(iBasicTree, Comparator.comparing(IBasicTreeItem::getData, comparator));
    }

    public static <KEYTYPE, DATATYPE extends Comparable<? super DATATYPE>, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void sortByValue(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree) {
        TreeWithIDSorter._sort(iBasicTree, (iTreeItemWithID, iTreeItemWithID2) -> ((Comparable)iTreeItemWithID.getData()).compareTo(iTreeItemWithID2.getData()));
    }
}

