/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.compare;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.compare.CompareHelper;
import com.helger.base.compare.IComparator;
import com.helger.text.compare.CollatorHelper;
import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class ComparatorHelper {
    private ComparatorHelper() {
    }

    public static @NonNull Comparator<String> getComparatorCollating(@Nullable Locale locale) {
        return ComparatorHelper.getComparatorCollating(CollatorHelper.getCollatorSpaceBeforeDot(locale));
    }

    public static @NonNull Comparator<String> getComparatorCollating(@NonNull Collator collator) {
        return Comparator.nullsFirst(collator::compare);
    }

    public static <T> @NonNull Comparator<T> getComparatorCollating(@NonNull Function<? super T, String> function, @Nullable Locale locale) {
        return Comparator.comparing(function, ComparatorHelper.getComparatorCollating(locale));
    }

    public static <T> @NonNull Comparator<T> getComparatorCollating(@NonNull Function<? super T, String> function, @NonNull Collator collator) {
        return Comparator.comparing(function, ComparatorHelper.getComparatorCollating(collator));
    }

    public static @NonNull IComparator<String> getComparatorStringLongestFirst() {
        return ComparatorHelper.getComparatorStringLongestFirst(true);
    }

    public static @NonNull IComparator<String> getComparatorStringLongestFirst(boolean bl) {
        return (IComparator & Serializable)(string3, string4) -> CompareHelper.compare((Object)string3, (Object)string4, (string, string2) -> {
            int n = string2.length() - string.length();
            return n != 0 ? n : string.compareTo((String)string2);
        }, (boolean)bl);
    }

    public static @NonNull IComparator<String> getComparatorStringShortestFirst() {
        return ComparatorHelper.getComparatorStringShortestFirst(true);
    }

    public static @NonNull IComparator<String> getComparatorStringShortestFirst(boolean bl) {
        return (IComparator & Serializable)(string3, string4) -> CompareHelper.compare((Object)string3, (Object)string4, (string, string2) -> {
            int n = string.length() - string2.length();
            return n != 0 ? n : string.compareTo((String)string2);
        }, (boolean)bl);
    }

    public static @NonNull IComparator<String> getComparatorStringIgnoreCase() {
        return ComparatorHelper.getComparatorStringIgnoreCase(true);
    }

    public static @NonNull IComparator<String> getComparatorStringIgnoreCase(boolean bl) {
        return (IComparator & Serializable)(string, string2) -> CompareHelper.compareIgnoreCase((String)string, (String)string2, (boolean)bl);
    }
}

