/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.resourcebundle;

import com.helger.annotation.concurrent.Immutable;
import com.helger.text.resourcebundle.Utf8PropertyResourceBundle;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.jspecify.annotations.NonNull;

@Immutable
public final class Utf8ResourceBundle {
    private static final Utf8ResourceBundle INSTANCE = new Utf8ResourceBundle();

    private Utf8ResourceBundle() {
    }

    private static @NonNull ResourceBundle _createUtf8PropertyResourceBundle(@NonNull ResourceBundle resourceBundle) {
        if (resourceBundle instanceof PropertyResourceBundle) {
            PropertyResourceBundle propertyResourceBundle = (PropertyResourceBundle)resourceBundle;
            return new Utf8PropertyResourceBundle(propertyResourceBundle);
        }
        return resourceBundle;
    }

    public static @NonNull ResourceBundle getBundle(@NonNull String string) {
        return Utf8ResourceBundle._createUtf8PropertyResourceBundle(ResourceBundle.getBundle(string, Locale.getDefault()));
    }

    public static @NonNull ResourceBundle getBundle(@NonNull String string, @NonNull Locale locale) {
        return Utf8ResourceBundle._createUtf8PropertyResourceBundle(ResourceBundle.getBundle(string, locale));
    }

    public static @NonNull ResourceBundle getBundle(@NonNull String string, @NonNull Locale locale, @NonNull ClassLoader classLoader) {
        return Utf8ResourceBundle._createUtf8PropertyResourceBundle(ResourceBundle.getBundle(string, locale, classLoader));
    }
}

