/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.resourcebundle;

import com.helger.annotation.PropertyKey;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.classloader.ClassLoaderHelper;
import com.helger.base.system.EJavaVersion;
import com.helger.text.resourcebundle.Utf8ResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ResourceBundleHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceBundleHelper.class);
    private static final ResourceBundleHelper INSTANCE = new ResourceBundleHelper();

    private ResourceBundleHelper() {
    }

    public static @Nullable ResourceBundle getResourceBundle(@NonNull String string, @NonNull Locale locale) {
        return ResourceBundleHelper.getResourceBundle(string, locale, ClassLoaderHelper.getDefaultClassLoader());
    }

    public static @Nullable ResourceBundle getResourceBundle(@NonNull String string, @NonNull Locale locale, @NonNull ClassLoader classLoader) {
        try {
            return ResourceBundle.getBundle(string, locale, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static @Nullable ResourceBundle getUtf8ResourceBundle(@NonNull String string, @NonNull Locale locale) {
        return ResourceBundleHelper.getUtf8ResourceBundle(string, locale, ClassLoaderHelper.getDefaultClassLoader());
    }

    public static @Nullable ResourceBundle getUtf8ResourceBundle(@NonNull String string, @NonNull Locale locale, @NonNull ClassLoader classLoader) {
        try {
            if (EJavaVersion.JDK_9.isSupportedVersion()) {
                return ResourceBundle.getBundle(string, locale, classLoader);
            }
            return Utf8ResourceBundle.getBundle(string, locale, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static @Nullable String getString(@Nullable ResourceBundle resourceBundle, @PropertyKey @NonNull String string) {
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public static @Nullable String getString(@NonNull String string, @NonNull Locale locale, @PropertyKey @NonNull String string2) {
        return ResourceBundleHelper.getString(ResourceBundleHelper.getResourceBundle(string, locale), string2);
    }

    public static @Nullable String getString(@NonNull String string, @NonNull Locale locale, @PropertyKey @NonNull String string2, @NonNull ClassLoader classLoader) {
        return ResourceBundleHelper.getString(ResourceBundleHelper.getResourceBundle(string, locale, classLoader), string2);
    }

    public static @Nullable String getUtf8String(@NonNull String string, @NonNull Locale locale, @PropertyKey @NonNull String string2) {
        return ResourceBundleHelper.getString(ResourceBundleHelper.getUtf8ResourceBundle(string, locale), string2);
    }

    public static @Nullable String getUtf8String(@NonNull String string, @NonNull Locale locale, @PropertyKey @NonNull String string2, @NonNull ClassLoader classLoader) {
        return ResourceBundleHelper.getString(ResourceBundleHelper.getUtf8ResourceBundle(string, locale, classLoader), string2);
    }

    public static void clearCache() {
        ResourceBundleHelper.clearCache(ClassLoaderHelper.getDefaultClassLoader());
    }

    public static void clearCache(@NonNull ClassLoader classLoader) {
        ResourceBundle.clearCache(classLoader);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cache was cleared: " + ResourceBundle.class.getName() + "; classloader=" + String.valueOf(classLoader));
        }
    }
}

