/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.format;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.text.format.AbstractFormatterString;
import org.jspecify.annotations.Nullable;

public final class FormatterMinLengthAddTrailing
extends AbstractFormatterString {
    private final int m_nMinLength;
    private final char m_cFill;

    public FormatterMinLengthAddTrailing(@Nonnegative int n, char c) {
        ValueEnforcer.isGT0((int)n, (String)"MinLength");
        this.m_nMinLength = n;
        this.m_cFill = c;
    }

    @Nonnegative
    public int getMinLength() {
        return this.m_nMinLength;
    }

    public char getFillChar() {
        return this.m_cFill;
    }

    @Override
    public String apply(@Nullable Object object) {
        String string = this.getValueAsString(object);
        if (string.length() >= this.m_nMinLength) {
            return string;
        }
        return string + StringHelper.getRepeated((char)this.m_cFill, (int)(this.m_nMinLength - string.length()));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FormatterMinLengthAddTrailing formatterMinLengthAddTrailing = (FormatterMinLengthAddTrailing)object;
        return this.m_nMinLength == formatterMinLengthAddTrailing.m_nMinLength && this.m_cFill == formatterMinLengthAddTrailing.m_cFill;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_nMinLength).append(this.m_cFill).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("minLength", this.m_nMinLength).append("fill", this.m_cFill).getToString();
    }
}

